module com.swirlds.platform.core {
    /* transitive */ requires com.hedera.node.hapi;
    /* transitive */ requires com.hedera.pbj.runtime;
    /* transitive */ requires com.swirlds.base;
    /* transitive */ requires com.swirlds.common;
    /* transitive */ requires com.swirlds.component.framework;
    /* transitive */ requires com.swirlds.config.api;
    /* transitive */ requires com.swirlds.metrics.api;
    /* transitive */ requires com.swirlds.state.api;
    /* transitive */ requires com.swirlds.state.impl;
    /* transitive */ requires com.swirlds.virtualmap;
    /* transitive */ requires org.hiero.base.concurrent;
    /* transitive */ requires org.hiero.base.crypto;
    /* transitive */ requires org.hiero.base.utility;
    /* transitive */ requires org.hiero.consensus.concurrent;
    /* transitive */ requires org.hiero.consensus.event.creator;
    /* transitive */ requires org.hiero.consensus.event.intake;
    /* transitive */ requires org.hiero.consensus.gossip.impl;
    /* transitive */ requires org.hiero.consensus.gossip;
    /* transitive */ requires org.hiero.consensus.hashgraph;
    /* transitive */ requires org.hiero.consensus.metrics;
    /* transitive */ requires org.hiero.consensus.model;
    /* transitive */ requires org.hiero.consensus.pces;
    /* transitive */ requires org.hiero.consensus.reconnect;
    /* transitive */ requires org.hiero.consensus.roster;
    /* transitive */ requires org.hiero.consensus.state;
    /* transitive */ requires org.hiero.consensus.utility;
    requires com.swirlds.config.extensions;
    requires com.swirlds.logging;
    requires com.swirlds.merkledb;
    requires org.hiero.consensus.pces.impl;
    requires org.hiero.consensus.platformstate;
    requires com.github.spotbugs.annotations;
    requires java.management;
    requires java.scripting;
    requires jdk.management;
    requires jdk.net;
    requires org.apache.logging.log4j;
    requires org.bouncycastle.pkix;
    requires org.bouncycastle.provider;

    exports com.swirlds.platform;
    exports com.swirlds.platform.builder;
    exports com.swirlds.platform.components;
    exports com.swirlds.platform.components.common.output;
    exports com.swirlds.platform.components.state.output;
    exports com.swirlds.platform.config;
    exports com.swirlds.platform.config.legacy;
    exports com.swirlds.platform.crypto;
    exports com.swirlds.platform.event.report;
    exports com.swirlds.platform.eventhandling;
    exports com.swirlds.platform.health;
    exports com.swirlds.platform.health.clock;
    exports com.swirlds.platform.health.entropy;
    exports com.swirlds.platform.health.filesystem;
    exports com.swirlds.platform.listeners;
    exports com.swirlds.platform.metrics;
    exports com.swirlds.platform.state;
    exports com.swirlds.platform.state.signed;
    exports com.swirlds.platform.state.address;
    exports com.swirlds.platform.scratchpad;
    exports com.swirlds.platform.system;
    exports com.swirlds.platform.system.transaction;
    exports com.swirlds.platform.system.state.notifications;
    exports com.swirlds.platform.system.status;
    exports com.swirlds.platform.system.status.actions;
    exports com.swirlds.platform.util;
    exports com.swirlds.platform.internal to org.hiero.consensus.pcli, com.swirlds.platform.core.test.fixtures, com.fasterxml.jackson.core, com.fasterxml.jackson.databind;
    exports com.swirlds.platform.uptime to com.swirlds.config.extensions, com.swirlds.config.impl, com.swirlds.common, com.hedera.node.test.clients;
    exports com.swirlds.platform.event.preconsensus;
    exports com.swirlds.platform.reconnect;
    exports com.swirlds.platform.event;
    exports com.swirlds.platform.wiring;
    exports com.swirlds.platform.wiring.components;
    exports com.swirlds.platform.state.snapshot;
    exports com.swirlds.platform.state.service.schemas;
    exports com.swirlds.platform.builder.internal;
    exports com.swirlds.platform.config.internal;
    exports com.swirlds.platform.state.iss to org.hiero.otter.test;
    exports com.swirlds.platform.recovery.internal to org.hiero.consensus.pcli;

    provides ConfigurationExtension with PlatformConfigurationExtension;
    provides ProtocolFactory with ReconnectProtocolFactory;

}

