/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.impl.internal.ConfigDataFactory;
import com.swirlds.config.impl.internal.ConfigLifecycle;
import com.swirlds.config.impl.internal.ConverterService;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class ConfigDataService
implements ConfigLifecycle {
    private final ConfigDataFactory configDataFactory;
    private final Queue<Class<? extends Record>> registeredTypes;
    private final Map<Class<? extends Record>, Record> configDataCache;
    private boolean initialized = false;

    ConfigDataService(@NonNull Configuration configuration, @NonNull ConverterService converterService) {
        this.configDataFactory = new ConfigDataFactory(configuration, converterService);
        this.configDataCache = new HashMap<Class<? extends Record>, Record>();
        this.registeredTypes = new ConcurrentLinkedQueue<Class<? extends Record>>();
    }

    <T extends Record> void addConfigDataType(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type must not be null");
        this.throwIfInitialized();
        this.registeredTypes.add(type);
    }

    @Override
    public void init() {
        this.throwIfInitialized();
        this.registeredTypes.stream().forEach(type -> {
            try {
                Object dataInstance = this.configDataFactory.createConfigInstance(type);
                this.configDataCache.put((Class<? extends Record>)type, (Record)dataInstance);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not create config data for record type '" + String.valueOf(type) + "'", e);
            }
        });
        this.initialized = true;
    }

    @Override
    public void dispose() {
        this.registeredTypes.clear();
        this.configDataCache.clear();
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @NonNull
    <T extends Record> T getConfigData(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type must not be null");
        this.throwIfNotInitialized();
        if (!this.configDataCache.containsKey(type)) {
            throw new IllegalArgumentException("No config data record available of type '" + String.valueOf(type) + "'");
        }
        return (T)this.configDataCache.get(type);
    }

    @NonNull
    public Collection<Class<? extends Record>> getConfigDataTypes() {
        return this.registeredTypes;
    }
}

