/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.consensus.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.state.consensus.schema.TopicSchema;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoArrayWriterTools;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.UnmodifiableArrayList;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TopicProtoCodec
implements Codec<Topic> {
    private static int $initialSizeOfUnknownFieldsArray = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NonNull
    public Topic parse(@NonNull ReadableSequentialData input, boolean strictMode, boolean parseUnknownFields, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            temp_topic_id = null;
            temp_sequence_number = 0L;
            temp_expiration_second = 0L;
            temp_auto_renew_period = 0L;
            temp_auto_renew_account_id = null;
            temp_deleted = false;
            temp_running_hash = Bytes.EMPTY;
            temp_memo = "";
            temp_admin_key = null;
            temp_submit_key = null;
            temp_fee_schedule_key = null;
            temp_fee_exempt_key_list = Collections.emptyList();
            temp_custom_fees = Collections.emptyList();
            $unknownFields = null;
            block40: while (input.hasRemaining()) {
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                field = tag >>> 3;
                f = TopicSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl32
                        value = TopicID.DEFAULT;
                        ** GOTO lbl47
lbl32:
                        // 1 sources

                        if (messageLength > maxSize) {
                            throw new ParseException("topic_id size " + messageLength + " is greater than max " + maxSize);
                        }
                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            value = (TopicID)TopicID.PROTOBUF.parse(input, strictMode, parseUnknownFields, maxDepth - 1, maxSize);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl47:
                        // 2 sources

                        temp_topic_id = value;
                        continue block40;
                    }
                    case 16: {
                        temp_sequence_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block40;
                    }
                    case 24: {
                        temp_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block40;
                    }
                    case 32: {
                        temp_auto_renew_period = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block40;
                    }
                    case 42: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl63
                        value = AccountID.DEFAULT;
                        ** GOTO lbl78
lbl63:
                        // 1 sources

                        if (messageLength > maxSize) {
                            throw new ParseException("auto_renew_account_id size " + messageLength + " is greater than max " + maxSize);
                        }
                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            value = (AccountID)AccountID.PROTOBUF.parse(input, strictMode, parseUnknownFields, maxDepth - 1, maxSize);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl78:
                        // 2 sources

                        temp_auto_renew_account_id = value;
                        continue block40;
                    }
                    case 48: {
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block40;
                    }
                    case 58: {
                        temp_running_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input, (long)maxSize);
                        continue block40;
                    }
                    case 66: {
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input, (long)maxSize);
                        continue block40;
                    }
                    case 74: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl94
                        value = Key.DEFAULT;
                        ** GOTO lbl109
lbl94:
                        // 1 sources

                        if (messageLength > maxSize) {
                            throw new ParseException("admin_key size " + messageLength + " is greater than max " + maxSize);
                        }
                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            value = (Key)Key.PROTOBUF.parse(input, strictMode, parseUnknownFields, maxDepth - 1, maxSize);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl109:
                        // 2 sources

                        temp_admin_key = value;
                        continue block40;
                    }
                    case 82: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl116
                        value = Key.DEFAULT;
                        ** GOTO lbl131
lbl116:
                        // 1 sources

                        if (messageLength > maxSize) {
                            throw new ParseException("submit_key size " + messageLength + " is greater than max " + maxSize);
                        }
                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            value = (Key)Key.PROTOBUF.parse(input, strictMode, parseUnknownFields, maxDepth - 1, maxSize);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl131:
                        // 2 sources

                        temp_submit_key = value;
                        continue block40;
                    }
                    case 90: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl138
                        value = Key.DEFAULT;
                        ** GOTO lbl153
lbl138:
                        // 1 sources

                        if (messageLength > maxSize) {
                            throw new ParseException("fee_schedule_key size " + messageLength + " is greater than max " + maxSize);
                        }
                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            value = (Key)Key.PROTOBUF.parse(input, strictMode, parseUnknownFields, maxDepth - 1, maxSize);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl153:
                        // 2 sources

                        temp_fee_schedule_key = value;
                        continue block40;
                    }
                    case 98: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl160
                        value = Key.DEFAULT;
                        ** GOTO lbl175
lbl160:
                        // 1 sources

                        if (messageLength > maxSize) {
                            throw new ParseException("fee_exempt_key_list size " + messageLength + " is greater than max " + maxSize);
                        }
                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            value = (Key)Key.PROTOBUF.parse(input, strictMode, parseUnknownFields, maxDepth - 1, maxSize);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl175:
                        // 2 sources

                        if (temp_fee_exempt_key_list.size() >= maxSize) {
                            throw new ParseException("fee_exempt_key_list size %d is greater than max maxSize".formatted(new Object[]{temp_fee_exempt_key_list.size()}));
                        }
                        temp_fee_exempt_key_list = ProtoParserTools.addToList(temp_fee_exempt_key_list, (Object)value);
                        continue block40;
                    }
                    case 106: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl184
                        value = FixedCustomFee.DEFAULT;
                        ** GOTO lbl199
lbl184:
                        // 1 sources

                        if (messageLength > maxSize) {
                            throw new ParseException("custom_fees size " + messageLength + " is greater than max " + maxSize);
                        }
                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            value = (FixedCustomFee)FixedCustomFee.PROTOBUF.parse(input, strictMode, parseUnknownFields, maxDepth - 1, maxSize);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl199:
                        // 2 sources

                        if (temp_custom_fees.size() >= maxSize) {
                            throw new ParseException("custom_fees size %d is greater than max maxSize".formatted(new Object[]{temp_custom_fees.size()}));
                        }
                        temp_custom_fees = ProtoParserTools.addToList(temp_custom_fees, (Object)value);
                        continue block40;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    if (parseUnknownFields) {
                        if ($unknownFields == null) {
                            $unknownFields = new ArrayList<UnknownField>(TopicProtoCodec.$initialSizeOfUnknownFieldsArray);
                        }
                        $unknownFields.add(new UnknownField(field, ProtoConstants.get((int)wireType), ProtoParserTools.extractField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType), (long)maxSize)));
                        continue;
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType), (long)maxSize);
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            if (temp_fee_exempt_key_list instanceof UnmodifiableArrayList) {
                ual = (UnmodifiableArrayList)temp_fee_exempt_key_list;
                ual.makeReadOnly();
            }
            if (temp_custom_fees instanceof UnmodifiableArrayList) {
                ual = (UnmodifiableArrayList)temp_custom_fees;
                ual.makeReadOnly();
            }
            if ($unknownFields != null) {
                Collections.sort($unknownFields);
                TopicProtoCodec.$initialSizeOfUnknownFieldsArray = Math.max(TopicProtoCodec.$initialSizeOfUnknownFieldsArray, $unknownFields.size());
            }
            return new Topic((TopicID)temp_topic_id, temp_sequence_number, temp_expiration_second, temp_auto_renew_period, (AccountID)temp_auto_renew_account_id, temp_deleted, temp_running_hash, temp_memo, (Key)temp_admin_key, (Key)temp_submit_key, (Key)temp_fee_schedule_key, temp_fee_exempt_key_list, temp_custom_fees, (List<UnknownField>)$unknownFields);
        }
        catch (Exception anyException) {
            if (anyException instanceof ParseException) {
                parseException = (ParseException)anyException;
                throw parseException;
            }
            throw new ParseException((Throwable)anyException);
        }
    }

    public void write(@NonNull Topic data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.TOPIC_ID, (Object)data.topicId(), TopicID.PROTOBUF);
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber(), (boolean)true);
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.EXPIRATION_SECOND, (long)data.expirationSecond(), (boolean)true);
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.AUTO_RENEW_PERIOD, (long)data.autoRenewPeriod(), (boolean)true);
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), AccountID.PROTOBUF);
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TopicSchema.DELETED, (boolean)data.deleted(), (boolean)true);
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TopicSchema.RUNNING_HASH, (RandomAccessData)data.runningHash(), (boolean)true);
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TopicSchema.MEMO, (String)data.memo(), (boolean)true);
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.ADMIN_KEY, (Object)data.adminKey(), Key.PROTOBUF);
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.SUBMIT_KEY, (Object)data.submitKey(), Key.PROTOBUF);
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.FEE_SCHEDULE_KEY, (Object)data.feeScheduleKey(), Key.PROTOBUF);
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TopicSchema.FEE_EXEMPT_KEY_LIST, data.feeExemptKeyList(), Key.PROTOBUF);
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TopicSchema.CUSTOM_FEES, data.customFees(), FixedCustomFee.PROTOBUF);
        if (!data.getUnknownFields().isEmpty()) {
            data.getUnknownFields().forEach(uf -> {
                int tag = uf.field() << 3 | uf.wireType().ordinal();
                out.writeVarInt(tag, false);
                uf.bytes().writeTo(out);
            });
        }
    }

    public int write(@NonNull Topic data, @NonNull byte[] output, int startOffset) {
        int offset = startOffset;
        offset += ProtoArrayWriterTools.writeMessage((byte[])output, (int)offset, (FieldDefinition)TopicSchema.TOPIC_ID, (Object)data.topicId(), TopicID.PROTOBUF);
        offset += ProtoArrayWriterTools.writeInt64((byte[])output, (int)offset, (FieldDefinition)TopicSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber(), (boolean)true);
        offset += ProtoArrayWriterTools.writeInt64((byte[])output, (int)offset, (FieldDefinition)TopicSchema.EXPIRATION_SECOND, (long)data.expirationSecond(), (boolean)true);
        offset += ProtoArrayWriterTools.writeInt64((byte[])output, (int)offset, (FieldDefinition)TopicSchema.AUTO_RENEW_PERIOD, (long)data.autoRenewPeriod(), (boolean)true);
        offset += ProtoArrayWriterTools.writeMessage((byte[])output, (int)offset, (FieldDefinition)TopicSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), AccountID.PROTOBUF);
        offset += ProtoArrayWriterTools.writeBoolean((byte[])output, (int)offset, (FieldDefinition)TopicSchema.DELETED, (boolean)data.deleted(), (boolean)true);
        offset += ProtoArrayWriterTools.writeBytes((byte[])output, (int)offset, (FieldDefinition)TopicSchema.RUNNING_HASH, (Bytes)data.runningHash(), (boolean)true);
        offset += ProtoArrayWriterTools.writeString((byte[])output, (int)offset, (FieldDefinition)TopicSchema.MEMO, (String)data.memo(), (boolean)true);
        offset += ProtoArrayWriterTools.writeMessage((byte[])output, (int)offset, (FieldDefinition)TopicSchema.ADMIN_KEY, (Object)data.adminKey(), Key.PROTOBUF);
        offset += ProtoArrayWriterTools.writeMessage((byte[])output, (int)offset, (FieldDefinition)TopicSchema.SUBMIT_KEY, (Object)data.submitKey(), Key.PROTOBUF);
        offset += ProtoArrayWriterTools.writeMessage((byte[])output, (int)offset, (FieldDefinition)TopicSchema.FEE_SCHEDULE_KEY, (Object)data.feeScheduleKey(), Key.PROTOBUF);
        offset += ProtoArrayWriterTools.writeMessageList((byte[])output, (int)offset, (FieldDefinition)TopicSchema.FEE_EXEMPT_KEY_LIST, data.feeExemptKeyList(), Key.PROTOBUF);
        offset += ProtoArrayWriterTools.writeMessageList((byte[])output, (int)offset, (FieldDefinition)TopicSchema.CUSTOM_FEES, data.customFees(), FixedCustomFee.PROTOBUF);
        for (UnknownField uf : data.getUnknownFields()) {
            int tag = uf.field() << 3 | uf.wireType().ordinal();
            offset += ProtoArrayWriterTools.writeUnsignedVarInt((byte[])output, (int)offset, (long)tag);
            offset += uf.bytes().writeTo(output, offset);
        }
        return offset - startOffset;
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Topic data) {
        return data.protobufSize();
    }

    public boolean fastEquals(@NonNull Topic item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    public Topic getDefaultInstance() {
        return Topic.DEFAULT;
    }
}

