/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.internal.network.codec;

import com.hedera.node.internal.network.HelidonHttpConfig;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class HelidonHttpConfigJsonCodec
implements JsonCodec<HelidonHttpConfig> {
    @NonNull
    public HelidonHttpConfig parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            String temp_flow_control_block_timeout = null;
            Integer temp_initial_window_size = null;
            Integer temp_max_frame_size = null;
            Long temp_max_header_list_size = null;
            String temp_name = null;
            Boolean temp_ping = null;
            String temp_ping_timeout = null;
            Boolean temp_prior_knowledge = null;
            block22: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "flowControlBlockTimeout": {
                        temp_flow_control_block_timeout = JsonTools.unescape((String)JsonTools.checkSize((String)"flow_control_block_timeout", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block22;
                    }
                    case "initialWindowSize": {
                        temp_initial_window_size = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "maxFrameSize": {
                        temp_max_frame_size = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "maxHeaderListSize": {
                        temp_max_header_list_size = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "name": {
                        temp_name = JsonTools.unescape((String)JsonTools.checkSize((String)"name", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block22;
                    }
                    case "ping": {
                        temp_ping = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "pingTimeout": {
                        temp_ping_timeout = JsonTools.unescape((String)JsonTools.checkSize((String)"ping_timeout", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block22;
                    }
                    case "priorKnowledge": {
                        temp_prior_knowledge = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new HelidonHttpConfig(temp_flow_control_block_timeout, temp_initial_window_size, temp_max_frame_size, temp_max_header_list_size, temp_name, temp_ping, temp_ping_timeout, temp_prior_knowledge);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull HelidonHttpConfig data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.flowControlBlockTimeout() != null) {
            fieldLines.add(JsonTools.field((String)"flowControlBlockTimeout", (String)data.flowControlBlockTimeout()));
        }
        if (data.initialWindowSize() != null) {
            fieldLines.add(JsonTools.field((String)"initialWindowSize", (Integer)data.initialWindowSize()));
        }
        if (data.maxFrameSize() != null) {
            fieldLines.add(JsonTools.field((String)"maxFrameSize", (Integer)data.maxFrameSize()));
        }
        if (data.maxHeaderListSize() != null) {
            fieldLines.add(JsonTools.field((String)"maxHeaderListSize", (Long)data.maxHeaderListSize(), (boolean)true));
        }
        if (data.name() != null) {
            fieldLines.add(JsonTools.field((String)"name", (String)data.name()));
        }
        if (data.ping() != null) {
            fieldLines.add(JsonTools.field((String)"ping", (Boolean)data.ping()));
        }
        if (data.pingTimeout() != null) {
            fieldLines.add(JsonTools.field((String)"pingTimeout", (String)data.pingTimeout()));
        }
        if (data.priorKnowledge() != null) {
            fieldLines.add(JsonTools.field((String)"priorKnowledge", (Boolean)data.priorKnowledge()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

