/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.io.streams;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import org.hiero.base.utility.CommonUtils;

public class AugmentedDataOutputStream
extends DataOutputStream {
    public AugmentedDataOutputStream(@NonNull OutputStream out) {
        super(out);
    }

    public void writeByteArray(@Nullable byte[] data, boolean writeChecksum) throws IOException {
        if (data == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(data.length);
        if (writeChecksum) {
            this.writeInt(101 - data.length);
        }
        this.write(data);
    }

    public void writeByteArray(@Nullable byte[] data) throws IOException {
        this.writeByteArray(data, false);
    }

    public void writeIntArray(@Nullable int[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            for (int datum : data) {
                this.writeInt(datum);
            }
        }
    }

    public void writeIntList(@Nullable List<Integer> data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.size());
            for (int datum : data) {
                this.writeInt(datum);
            }
        }
    }

    public void writeLongArray(@Nullable long[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            for (long datum : data) {
                this.writeLong(datum);
            }
        }
    }

    public void writeLongList(@Nullable List<Long> data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.size());
            for (long datum : data) {
                this.writeLong(datum);
            }
        }
    }

    public void writeBooleanList(@Nullable List<Boolean> data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.size());
            for (boolean datum : data) {
                this.writeBoolean(datum);
            }
        }
    }

    public void writeFloatArray(@Nullable float[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            for (float datum : data) {
                this.writeFloat(datum);
            }
        }
    }

    public void writeFloatList(@Nullable List<Float> data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.size());
            for (Float datum : data) {
                this.writeFloat(datum.floatValue());
            }
        }
    }

    public void writeDoubleArray(@Nullable double[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            for (double datum : data) {
                this.writeDouble(datum);
            }
        }
    }

    public void writeDoubleList(@Nullable List<Double> data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.size());
            for (Double datum : data) {
                this.writeDouble(datum);
            }
        }
    }

    public void writeStringArray(@Nullable String[] data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            for (String datum : data) {
                this.writeNormalisedString(datum);
            }
        }
    }

    public void writeStringList(@Nullable List<String> data) throws IOException {
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.size());
            for (String datum : data) {
                this.writeNormalisedString(datum);
            }
        }
    }

    public void writeNormalisedString(@Nullable String s) throws IOException {
        byte[] data = CommonUtils.getNormalisedStringBytes(s);
        this.writeByteArray(data);
    }

    public void writeInstant(@Nullable Instant instant) throws IOException {
        if (instant == null) {
            this.writeLong(Long.MIN_VALUE);
            return;
        }
        this.writeLong(instant.getEpochSecond());
        this.writeLong(instant.getNano());
    }

    public static int getArraySerializedLength(@Nullable long[] data) {
        int totalByteLength = 4;
        return totalByteLength += data == null ? 0 : data.length * 8;
    }

    public static int getArraySerializedLength(@Nullable int[] data) {
        int totalByteLength = 4;
        return totalByteLength += data == null ? 0 : data.length * 4;
    }

    public static int getArraySerializedLength(@Nullable byte[] data) {
        return AugmentedDataOutputStream.getArraySerializedLength(data, false);
    }

    public static int getArraySerializedLength(@Nullable byte[] data, boolean writeChecksum) {
        int totalByteLength = 4;
        if (writeChecksum) {
            totalByteLength += 4;
        }
        return totalByteLength += data == null ? 0 : data.length;
    }
}

