/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class DivOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult divSuccess = new Operation.OperationResult(5L, null);

    public DivOperation(GasCalculator gasCalculator) {
        super(4, "DIV", 2, 1, gasCalculator, gasCalculator.getLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return DivOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        if (value1.isZero()) {
            frame.pushStackItem(Bytes.EMPTY);
        } else {
            BigInteger b2;
            BigInteger b1 = new BigInteger(1, value0.toArrayUnsafe());
            BigInteger result = b1.divide(b2 = new BigInteger(1, value1.toArrayUnsafe()));
            byte[] resultArray = result.toByteArray();
            int length = resultArray.length;
            if (length > 32) {
                frame.pushStackItem(Bytes.wrap((byte[])resultArray, (int)(length - 32), (int)32));
            } else {
                frame.pushStackItem(Bytes.wrap((byte[])resultArray));
            }
        }
        return divSuccess;
    }
}

