/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.recovery.internal.EventStreamLowerBound;
import com.swirlds.platform.recovery.internal.EventStreamMultiFileIterator;
import com.swirlds.platform.recovery.internal.EventStreamRoundLowerBound;
import com.swirlds.platform.recovery.internal.StreamedRound;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.model.event.CesEvent;

public class EventStreamRoundIterator
implements IOIterator<StreamedRound> {
    private final IOIterator<CesEvent> eventIterator;
    private final boolean allowPartialRound;
    private final Roster consensusRoster;
    private StreamedRound next;
    private boolean ended = false;

    public EventStreamRoundIterator(@NonNull Roster consensusRoster, Path eventStreamDirectory, long startingRound, boolean allowPartialRound) throws IOException {
        this(consensusRoster, new EventStreamMultiFileIterator(eventStreamDirectory, (EventStreamLowerBound)new EventStreamRoundLowerBound(startingRound)), allowPartialRound);
    }

    public EventStreamRoundIterator(@NonNull Roster consensusRoster, IOIterator<CesEvent> eventIterator, boolean allowPartialRound) {
        this.consensusRoster = Objects.requireNonNull(consensusRoster);
        this.eventIterator = Objects.requireNonNull(eventIterator);
        this.allowPartialRound = allowPartialRound;
    }

    public boolean hasNext() throws IOException {
        CesEvent lastEvent;
        if (this.ended) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        if (!this.eventIterator.hasNext()) {
            return false;
        }
        ArrayList<CesEvent> events = new ArrayList<CesEvent>();
        long round = ((CesEvent)this.eventIterator.peek()).getRoundReceived();
        while (this.eventIterator.hasNext() && ((CesEvent)this.eventIterator.peek()).getRoundReceived() == round) {
            events.add((CesEvent)this.eventIterator.next());
        }
        if (!this.allowPartialRound && !(lastEvent = (CesEvent)events.get(events.size() - 1)).isLastInRoundReceived()) {
            this.ended = true;
            return false;
        }
        this.next = new StreamedRound(this.consensusRoster, events, round);
        return true;
    }

    public void close() {
        this.eventIterator.close();
    }

    public StreamedRound peek() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    public StreamedRound next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            StreamedRound streamedRound = this.next;
            return streamedRound;
        }
        finally {
            this.next = null;
        }
    }
}

