/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.iss;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.Mnemonics;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.IssPayload;
import com.swirlds.platform.metrics.IssMetrics;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.internal.ConsensusHashFinder;
import com.swirlds.platform.state.iss.internal.HashValidityStatus;
import com.swirlds.platform.state.iss.internal.RoundHashValidator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.notification.IssNotification;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;
import org.hiero.consensus.model.sequence.set.SequenceSet;
import org.hiero.consensus.model.sequence.set.StandardSequenceSet;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.roster.RosterUtils;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public class DefaultIssDetector
implements IssDetector {
    private static final Logger logger = LogManager.getLogger(DefaultIssDetector.class);
    private final SequenceMap<Long, RoundHashValidator> roundData;
    private final SequenceSet<ScopedSystemTransaction<StateSignatureTransaction>> savedSignatures;
    private long previousRound = -1L;
    private final Roster roster;
    private final RateLimiter lackingSignaturesRateLimiter;
    private final RateLimiter selfIssRateLimiter;
    private final RateLimiter catastrophicIssRateLimiter;
    private final boolean ignorePreconsensusSignatures;
    private boolean replayingPreconsensusStream = true;
    private final long ignoredRound;
    private final IssMetrics issMetrics;
    private final long latestFreezeRound;

    public DefaultIssDetector(@NonNull PlatformContext platformContext, @NonNull Roster roster, boolean ignorePreconsensusSignatures, long ignoredRound, long latestFreezeRound) {
        Objects.requireNonNull(platformContext);
        ConsensusConfig consensusConfig = (ConsensusConfig)platformContext.getConfiguration().getConfigData(ConsensusConfig.class);
        StateConfig stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        Duration timeBetweenIssLogs = Duration.ofSeconds(stateConfig.secondsBetweenIssLogs());
        this.lackingSignaturesRateLimiter = new RateLimiter(platformContext.getTime(), timeBetweenIssLogs);
        this.selfIssRateLimiter = new RateLimiter(platformContext.getTime(), timeBetweenIssLogs);
        this.catastrophicIssRateLimiter = new RateLimiter(platformContext.getTime(), timeBetweenIssLogs);
        this.roster = Objects.requireNonNull(roster);
        this.roundData = new StandardSequenceMap((long)(-consensusConfig.roundsNonAncient()), consensusConfig.roundsNonAncient(), x -> x);
        this.savedSignatures = new StandardSequenceSet(0L, consensusConfig.roundsNonAncient(), s -> ((StateSignatureTransaction)s.transaction()).round());
        this.ignorePreconsensusSignatures = ignorePreconsensusSignatures;
        if (ignorePreconsensusSignatures) {
            logger.info(LogMarker.STARTUP.getMarker(), "State signatures from the preconsensus event stream will be ignored.");
        }
        this.ignoredRound = ignoredRound;
        if (ignoredRound != -1L) {
            logger.warn(LogMarker.STARTUP.getMarker(), "No ISS detection will be performed for round {}", (Object)ignoredRound);
        }
        this.issMetrics = new IssMetrics(platformContext.getMetrics(), roster);
        this.latestFreezeRound = latestFreezeRound;
    }

    @Override
    public void signalEndOfPreconsensusReplay() {
        this.replayingPreconsensusStream = false;
    }

    @Nullable
    private IssNotification maybeCreateIssNotification(long roundNumber, @NonNull IssNotification.IssType issType) {
        if (roundNumber == this.ignoredRound) {
            return null;
        }
        return new IssNotification(roundNumber, issType);
    }

    @NonNull
    private List<IssNotification> shiftRoundDataWindow(long roundNumber) {
        if (roundNumber <= this.previousRound) {
            throw new IllegalArgumentException("previous round was " + this.previousRound + ", can't decrease round to " + roundNumber);
        }
        long oldestRoundToValidate = roundNumber - (long)this.roundData.getSequenceNumberCapacity() + 1L;
        ArrayList removedRounds = new ArrayList();
        if (roundNumber != this.previousRound + 1L) {
            this.roundData.shiftWindow(oldestRoundToValidate);
        } else {
            this.roundData.shiftWindow(oldestRoundToValidate, (k, v) -> removedRounds.add(v));
        }
        this.previousRound = roundNumber;
        this.roundData.put((Object)roundNumber, (Object)new RoundHashValidator(roundNumber, RosterUtils.computeTotalWeight((Roster)this.roster), this.issMetrics));
        return removedRounds.stream().map(this::handleRemovedRound).filter(Objects::nonNull).toList();
    }

    @Override
    @NonNull
    public List<IssNotification> handleStateSignatureTransactions(@NonNull Collection<ScopedSystemTransaction<StateSignatureTransaction>> systemTransactions) {
        ArrayList<IssNotification> issNotifications = new ArrayList<IssNotification>();
        for (ScopedSystemTransaction<StateSignatureTransaction> transaction : systemTransactions) {
            StateSignatureTransaction signaturePayload = (StateSignatureTransaction)transaction.transaction();
            long round = signaturePayload.round();
            if (round < this.savedSignatures.getFirstSequenceNumberInWindow()) {
                IssNotification issNotification = this.handlePostconsensusSignature(transaction);
                if (issNotification == null) continue;
                issNotifications.add(issNotification);
                continue;
            }
            this.savedSignatures.add(transaction);
        }
        return issNotifications;
    }

    @Override
    @Nullable
    public List<IssNotification> handleState(@NonNull ReservedSignedState reservedSignedState) {
        try (ReservedSignedState reservedSignedState2 = reservedSignedState;){
            SignedState state = reservedSignedState.get();
            long roundNumber = state.getRound();
            ArrayList<IssNotification> issNotifications = new ArrayList<IssNotification>(this.shiftRoundDataWindow(roundNumber));
            issNotifications.addAll(this.applySignaturesAndShiftWindow(roundNumber));
            IssNotification selfHashCheckResult = this.checkSelfStateHash(roundNumber, state.getState().getHash());
            if (selfHashCheckResult != null) {
                issNotifications.add(selfHashCheckResult);
            }
            ArrayList<IssNotification> arrayList = issNotifications.isEmpty() ? null : issNotifications;
            return arrayList;
        }
    }

    @NonNull
    private List<IssNotification> applySignaturesAndShiftWindow(long roundNumber) {
        ArrayList<IssNotification> issNotifications = new ArrayList<IssNotification>(this.handlePostconsensusSignatures(this.savedSignatures.getEntriesWithSequenceNumber(roundNumber)));
        this.savedSignatures.shiftWindow(roundNumber + 1L);
        return issNotifications;
    }

    @Nullable
    private IssNotification handleRemovedRound(@NonNull RoundHashValidator roundHashValidator) {
        boolean justDecided = roundHashValidator.outOfTime();
        StringBuilder sb = new StringBuilder();
        roundHashValidator.getHashFinder().writePartitionData(sb);
        logger.info(LogMarker.STATE_HASH.getMarker(), (CharSequence)sb);
        if (justDecided) {
            HashValidityStatus status = roundHashValidator.getStatus();
            if (status == HashValidityStatus.CATASTROPHIC_ISS || status == HashValidityStatus.CATASTROPHIC_LACK_OF_DATA) {
                IssNotification notification = this.maybeCreateIssNotification(roundHashValidator.getRound(), IssNotification.IssType.CATASTROPHIC_ISS);
                if (notification != null) {
                    this.handleCatastrophic(roundHashValidator);
                }
                return notification;
            }
            if (status == HashValidityStatus.LACK_OF_DATA) {
                this.handleLackOfData(roundHashValidator);
            } else {
                throw new IllegalStateException("Unexpected hash validation status " + String.valueOf((Object)status) + ", should have decided prior to now");
            }
        }
        return null;
    }

    @NonNull
    private List<IssNotification> handlePostconsensusSignatures(List<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactions) {
        if (stateSignatureTransactions == null) {
            return List.of();
        }
        return stateSignatureTransactions.stream().map(this::handlePostconsensusSignature).filter(Objects::nonNull).toList();
    }

    @Nullable
    private IssNotification handlePostconsensusSignature(@NonNull ScopedSystemTransaction<StateSignatureTransaction> transaction) {
        NodeId signerId = transaction.submitterId();
        StateSignatureTransaction signaturePayload = (StateSignatureTransaction)transaction.transaction();
        if (this.ignorePreconsensusSignatures && this.replayingPreconsensusStream) {
            return null;
        }
        if (transaction.eventBirthRound() <= this.latestFreezeRound) {
            return null;
        }
        RosterEntry node = RosterUtils.getRosterEntryOrNull((Roster)this.roster, (long)signerId.id());
        if (node == null) {
            return null;
        }
        if (signaturePayload.round() == this.ignoredRound) {
            return null;
        }
        RoundHashValidator roundValidator = (RoundHashValidator)this.roundData.get((Object)signaturePayload.round());
        if (roundValidator == null) {
            return null;
        }
        boolean decided = roundValidator.reportHashFromNetwork(signerId, node.weight(), new Hash(signaturePayload.hash()));
        if (decided) {
            return this.checkValidity(roundValidator);
        }
        return null;
    }

    @Nullable
    private IssNotification checkSelfStateHash(long round, @NonNull Hash hash) {
        RoundHashValidator roundHashValidator = (RoundHashValidator)this.roundData.get((Object)round);
        if (roundHashValidator == null) {
            throw new IllegalStateException("Hash reported for round " + round + ", but that round is not being tracked");
        }
        boolean decided = roundHashValidator.reportSelfHash(hash);
        if (decided) {
            return this.checkValidity(roundHashValidator);
        }
        return null;
    }

    @Override
    @Nullable
    public List<IssNotification> overridingState(@NonNull ReservedSignedState state) {
        try (ReservedSignedState reservedSignedState = state;){
            long roundNumber = state.get().getRound();
            this.shiftRoundDataWindow(roundNumber);
            List<IssNotification> issNotifications = this.applySignaturesAndShiftWindow(roundNumber);
            Hash stateHash = state.get().getState().getHash();
            IssNotification issNotification = this.checkSelfStateHash(roundNumber, stateHash);
            if (issNotification != null) {
                issNotifications.add(issNotification);
            }
            if (issNotifications.isEmpty()) {
                List<IssNotification> list = null;
                return list;
            }
            logger.warn(LogMarker.SIGNED_STATE.getMarker(), "An ISS was detected for an overriding state for round {}. This should not be possible.", (Object)roundNumber);
            List<IssNotification> list = issNotifications;
            return list;
        }
    }

    @Nullable
    private IssNotification checkValidity(@NonNull RoundHashValidator roundValidator) {
        long round = roundValidator.getRound();
        return switch (roundValidator.getStatus()) {
            case HashValidityStatus.VALID -> {
                if (roundValidator.hasDisagreement()) {
                    yield this.maybeCreateIssNotification(round, IssNotification.IssType.OTHER_ISS);
                }
                yield null;
            }
            case HashValidityStatus.SELF_ISS -> {
                IssNotification notification = this.maybeCreateIssNotification(round, IssNotification.IssType.SELF_ISS);
                if (notification != null) {
                    this.handleSelfIss(roundValidator);
                }
                yield notification;
            }
            case HashValidityStatus.CATASTROPHIC_ISS -> {
                IssNotification notification = this.maybeCreateIssNotification(round, IssNotification.IssType.CATASTROPHIC_ISS);
                if (notification != null) {
                    this.handleCatastrophic(roundValidator);
                }
                yield notification;
            }
            case HashValidityStatus.UNDECIDED -> throw new IllegalStateException("status is undecided, but method reported a decision, round = " + round);
            case HashValidityStatus.LACK_OF_DATA -> throw new IllegalStateException("a decision that we lack data should only be possible once time runs out, round = " + round);
            default -> throw new IllegalStateException("unhandled case " + String.valueOf((Object)roundValidator.getStatus()) + ", round = " + round);
        };
    }

    private void handleSelfIss(@NonNull RoundHashValidator roundHashValidator) {
        long round = roundHashValidator.getRound();
        Hash selfHash = roundHashValidator.getSelfStateHash();
        Hash consensusHash = roundHashValidator.getConsensusHash();
        long skipCount = this.selfIssRateLimiter.getDeniedRequests();
        if (this.selfIssRateLimiter.requestAndTrigger()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid State Signature (ISS): this node has the wrong hash for round ").append(round).append(".\n");
            roundHashValidator.getHashFinder().writePartitionData(sb);
            DefaultIssDetector.writeSkippedLogCount(sb, skipCount);
            logger.fatal(LogMarker.EXCEPTION.getMarker(), (Object)new IssPayload(sb.toString(), round, Mnemonics.generateMnemonic((Hash)selfHash), Mnemonics.generateMnemonic((Hash)consensusHash), false));
        }
    }

    private void handleCatastrophic(@NonNull RoundHashValidator roundHashValidator) {
        long round = roundHashValidator.getRound();
        ConsensusHashFinder hashFinder = roundHashValidator.getHashFinder();
        Hash selfHash = roundHashValidator.getSelfStateHash();
        long skipCount = this.catastrophicIssRateLimiter.getDeniedRequests();
        if (this.catastrophicIssRateLimiter.requestAndTrigger()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Catastrophic Invalid State Signature (ISS)\n");
            sb.append("Due to divergence in state hash between many network members, this network is incapable of continued operation without human intervention.\n");
            hashFinder.writePartitionData(sb);
            DefaultIssDetector.writeSkippedLogCount(sb, skipCount);
            String mnemonic = selfHash == null ? "null" : Mnemonics.generateMnemonic((Hash)selfHash);
            logger.fatal(LogMarker.EXCEPTION.getMarker(), (Object)new IssPayload(sb.toString(), round, mnemonic, "", true));
        }
    }

    private void handleLackOfData(@NonNull RoundHashValidator roundHashValidator) {
        long skipCount = this.lackingSignaturesRateLimiter.getDeniedRequests();
        if (!this.lackingSignaturesRateLimiter.requestAndTrigger()) {
            return;
        }
        long round = roundHashValidator.getRound();
        ConsensusHashFinder hashFinder = roundHashValidator.getHashFinder();
        Hash selfHash = roundHashValidator.getSelfStateHash();
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to collect enough data to determine the consensus hash for round ").append(round).append(".\n");
        if (selfHash == null) {
            sb.append("No self hash was computed. This is highly unusual.\n");
        }
        hashFinder.writePartitionData(sb);
        DefaultIssDetector.writeSkippedLogCount(sb, skipCount);
        logger.warn(LogMarker.STATE_HASH.getMarker(), (CharSequence)sb);
    }

    private static void writeSkippedLogCount(@NonNull StringBuilder sb, long skipCount) {
        if (skipCount > 0L) {
            sb.append("This condition has been triggered ").append(skipCount).append(" time(s) over the last ").append(Duration.ofMinutes(1L).toSeconds()).append("seconds.");
        }
    }
}

