/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.signed.SignedStateHistory;

public class DefaultSignedStateSentinel
implements SignedStateSentinel {
    private static final Logger logger = LogManager.getLogger(DefaultSignedStateSentinel.class);
    private final RateLimiter rateLimiter;
    private final Duration maxSignedStateAge;

    public DefaultSignedStateSentinel(@NonNull PlatformContext platformContext) {
        StateConfig stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        this.maxSignedStateAge = stateConfig.suspiciousSignedStateAgeGap();
        Duration rateLimitPeriod = stateConfig.signedStateAgeNotifyRateLimit();
        this.rateLimiter = new RateLimiter(Time.getCurrent(), rateLimitPeriod);
    }

    @Override
    public void checkSignedStates(@NonNull Instant now) {
        if (!this.rateLimiter.request()) {
            return;
        }
        RuntimeObjectRecord oldest = RuntimeObjectRegistry.getOldestActiveObjectRecord(SignedState.class);
        if (oldest == null) {
            return;
        }
        RuntimeObjectRecord newest = RuntimeObjectRegistry.getNewestActiveObjectRecord(SignedState.class);
        if (newest == null) {
            return;
        }
        Duration signedStateGap = Duration.between(oldest.getCreationTime(), newest.getCreationTime());
        if (CompareTo.isGreaterThan((Comparable)signedStateGap, (Object)this.maxSignedStateAge) && this.rateLimiter.requestAndTrigger()) {
            SignedStateHistory history = (SignedStateHistory)oldest.getMetadata();
            logger.error(LogMarker.EXCEPTION.getMarker(), "Old signed state detected. The most likely causes are either that the node has gotten stuck or that there has been a memory leak.\n{}", (Object)history);
        }
    }
}

