/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.quiescence;

import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.quiescence.BadMetadataException;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import org.hiero.consensus.model.transaction.Transaction;

public final class QuiescenceUtils {
    private QuiescenceUtils() {
    }

    public static boolean isRelevantTransaction(@NonNull TransactionBody body) {
        return !body.hasStateSignatureTransaction() && !body.hasHintsPartialSignature();
    }

    public static boolean isRelevantTransaction(@NonNull Transaction txn) throws BadMetadataException {
        Object object = txn.getMetadata();
        if (!(object instanceof PreHandleResult)) {
            throw new BadMetadataException(txn);
        }
        PreHandleResult preHandleResult = (PreHandleResult)object;
        TransactionInfo txInfo = preHandleResult.txInfo();
        if (txInfo == null) {
            return true;
        }
        return QuiescenceUtils.isRelevantTransaction(txInfo.txBody());
    }

    public static long countRelevantTransactions(@NonNull Iterator<Transaction> transactions) throws BadMetadataException {
        long count = 0L;
        while (transactions.hasNext()) {
            if (!QuiescenceUtils.isRelevantTransaction(transactions.next())) continue;
            ++count;
        }
        return count;
    }
}

