/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.hedera.node.app.services.ServicesRegistry;
import com.hedera.node.app.state.merkle.MerkleSchemaRegistry;
import com.hedera.node.app.state.merkle.SchemaApplications;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableRegistry;

@Singleton
public final class ServicesRegistryImpl
implements ServicesRegistry {
    private static final Logger logger = LogManager.getLogger(ServicesRegistryImpl.class);
    private final ConstructableRegistry constructableRegistry;
    private final SortedSet<ServicesRegistry.Registration> entries;
    private final Configuration bootstrapConfig;

    @Inject
    public ServicesRegistryImpl(@NonNull ConstructableRegistry constructableRegistry, @NonNull Configuration bootstrapConfig) {
        this.constructableRegistry = Objects.requireNonNull(constructableRegistry);
        this.bootstrapConfig = Objects.requireNonNull(bootstrapConfig);
        this.entries = new TreeSet<ServicesRegistry.Registration>();
    }

    @Override
    @NonNull
    public ServicesRegistry subRegistryFor(String ... serviceNames) {
        Objects.requireNonNull(serviceNames);
        Set<String> selections = Set.of(serviceNames);
        ServicesRegistryImpl subRegistry = new ServicesRegistryImpl(this.constructableRegistry, this.bootstrapConfig);
        subRegistry.entries.addAll(this.entries.stream().filter(registration -> selections.contains(registration.serviceName())).toList());
        return subRegistry;
    }

    @Override
    public void register(@NonNull Service service) {
        String serviceName = service.getServiceName();
        logger.debug("Registering schemas for service {}", (Object)serviceName);
        MerkleSchemaRegistry registry = new MerkleSchemaRegistry(serviceName, new SchemaApplications());
        service.registerSchemas((SchemaRegistry)registry);
        this.entries.add(new ServicesRegistry.Registration(service, registry));
        logger.info("Registered service {} with implementation {}", (Object)service.getServiceName(), (Object)service.getClass());
    }

    @NonNull
    public SortedSet<ServicesRegistry.Registration> registrations() {
        return Collections.unmodifiableSortedSet(this.entries);
    }
}

