/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.StateInitializer;
import com.swirlds.platform.builder.PlatformBuildingBlocks;
import com.swirlds.platform.builder.PlatformComponentBuilder;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.components.DefaultAppNotifier;
import com.swirlds.platform.components.DefaultEventWindowManager;
import com.swirlds.platform.components.DefaultSavedStateController;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.event.preconsensus.PcesReplayer;
import com.swirlds.platform.metrics.RuntimeMetrics;
import com.swirlds.platform.reconnect.DefaultSignedStateValidator;
import com.swirlds.platform.reconnect.ReconnectController;
import com.swirlds.platform.state.address.RosterMetrics;
import com.swirlds.platform.state.nexus.DefaultLatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.LockFreeStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.DefaultStateSignatureCollector;
import com.swirlds.platform.state.signed.SignedStateMetrics;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SignedStateFilePath;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.status.actions.DoneReplayingEventsAction;
import com.swirlds.platform.system.status.actions.StartedReplayingEventsAction;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformCoordinator;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.pces.config.PcesConfig;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.round.EventWindowUtils;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public class SwirldsPlatform
implements Platform {
    private static final Logger logger = LogManager.getLogger(SwirldsPlatform.class);
    private final NodeId selfId;
    private final Roster currentRoster;
    private final KeysAndCerts keysAndCerts;
    private final long initialAncientThreshold;
    private final long startingRound;
    private final SignedStateNexus latestImmutableStateNexus = new LockFreeStateNexus();
    private final NotificationEngine notificationEngine;
    private final PlatformContext platformContext;
    private final SavedStateController savedStateController;
    private final PlatformComponents platformComponents;
    private final long pcesReplayLowerBound;
    private final PlatformCoordinator platformCoordinator;

    public SwirldsPlatform(@NonNull PlatformComponentBuilder builder) {
        PlatformBuildingBlocks blocks = builder.getBuildingBlocks();
        this.platformContext = blocks.platformContext();
        SignedState initialState = blocks.initialState().get();
        this.selfId = blocks.selfId();
        this.notificationEngine = blocks.notificationEngine();
        logger.info(LogMarker.STARTUP.getMarker(), "Starting with roster history:\n{}", (Object)blocks.rosterHistory());
        this.currentRoster = blocks.rosterHistory().getCurrentRoster();
        Metrics metrics = this.platformContext.getMetrics();
        RosterMetrics.registerRosterMetrics(metrics, this.currentRoster, this.selfId);
        RuntimeMetrics.setup(metrics);
        this.keysAndCerts = blocks.keysAndCerts();
        DefaultLatestCompleteStateNexus latestCompleteStateNexus = new DefaultLatestCompleteStateNexus(this.platformContext);
        this.savedStateController = new DefaultSavedStateController(this.platformContext);
        SignedStateMetrics signedStateMetrics = new SignedStateMetrics(metrics);
        DefaultStateSignatureCollector stateSignatureCollector = new DefaultStateSignatureCollector(this.platformContext, signedStateMetrics);
        this.platformComponents = blocks.platformComponents();
        this.platformCoordinator = new PlatformCoordinator(blocks.platformComponents(), blocks.applicationCallbacks());
        blocks.statusActionSubmitterReference().set(this.platformCoordinator);
        Configuration configuration = this.platformContext.getConfiguration();
        Duration replayHealthThreshold = ((PcesConfig)configuration.getConfigData(PcesConfig.class)).replayHealthThreshold();
        PcesReplayer pcesReplayer = new PcesReplayer(configuration, this.platformContext.getTime(), this.platformComponents.pcesReplayerWiring().eventOutput(), this.platformCoordinator::flushIntakePipeline, this.platformCoordinator::flushTransactionHandler, () -> this.latestImmutableStateNexus.getState("PCES replay"), () -> CompareTo.isLessThan((Comparable)blocks.model().getUnhealthyDuration(), (Object)replayHealthThreshold));
        StateInitializer.initializeState(this, initialState, blocks.consensusStateEventHandler());
        StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager = blocks.stateLifecycleManager();
        VirtualMapState state = initialState.getState();
        stateLifecycleManager.initState((Object)state);
        if (!initialState.isGenesisState()) {
            PlatformStateUtils.setCreationSoftwareVersionTo((State)((State)stateLifecycleManager.getMutableState()), (SemanticVersion)blocks.appVersion());
        }
        DefaultEventWindowManager eventWindowManager = new DefaultEventWindowManager();
        DefaultAppNotifier appNotifier = new DefaultAppNotifier(blocks.notificationEngine());
        ReconnectController reconnectController = new ReconnectController(configuration, this.platformContext.getTime(), this.currentRoster, this, this.platformCoordinator, stateLifecycleManager, this.savedStateController, blocks.consensusStateEventHandler(), blocks.reservedSignedStateResultPromise(), this.selfId, blocks.fallenBehindMonitor(), new DefaultSignedStateValidator());
        Thread reconnectControllerThread = ((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("platform-core")).setThreadName("reconnectController")).setRunnable((Runnable)reconnectController).build(true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            reconnectController.stopReconnectLoop();
            reconnectControllerThread.interrupt();
        }));
        this.platformComponents.bind(builder, pcesReplayer, stateSignatureCollector, eventWindowManager, this.latestImmutableStateNexus, latestCompleteStateNexus, this.savedStateController, appNotifier);
        Hash legacyRunningEventHash = PlatformStateUtils.legacyRunningEventHashOf((State)initialState.getState()) == null ? Cryptography.NULL_HASH : PlatformStateUtils.legacyRunningEventHashOf((State)initialState.getState());
        RunningEventHashOverride runningEventHashOverride = new RunningEventHashOverride(legacyRunningEventHash, false);
        this.platformCoordinator.updateRunningHash(runningEventHashOverride);
        String actualMainClassName = ((StateConfig)configuration.getConfigData(StateConfig.class)).getMainClassName(blocks.mainClassName());
        SignedStateFilePath statePath = new SignedStateFilePath((StateCommonConfig)configuration.getConfigData(StateCommonConfig.class));
        List<SavedStateInfo> savedStates = statePath.getSavedStateFiles(actualMainClassName, this.selfId, blocks.swirldName());
        if (!savedStates.isEmpty()) {
            long minimumGenerationNonAncientForOldestState = savedStates.get(savedStates.size() - 1).metadata().minimumBirthRoundNonAncient();
            this.platformCoordinator.injectPcesMinimumGenerationToStore(minimumGenerationNonAncientForOldestState);
        }
        boolean startedFromGenesis = initialState.isGenesisState();
        this.latestImmutableStateNexus.setState(initialState.reserve("set latest immutable to initial state"));
        if (startedFromGenesis) {
            this.initialAncientThreshold = 0L;
            this.startingRound = 0L;
            this.platformCoordinator.updateEventWindow(EventWindow.getGenesisEventWindow());
        } else {
            this.initialAncientThreshold = PlatformStateUtils.ancientThresholdOf((State)initialState.getState());
            this.startingRound = initialState.getRound();
            this.platformCoordinator.sendStateToHashLogger(initialState);
            this.platformCoordinator.injectSignatureCollectorState(initialState.reserve("loading initial state into sig collector"));
            this.savedStateController.registerSignedStateFromDisk(initialState);
            ConsensusSnapshot consensusSnapshot = Objects.requireNonNull(PlatformStateUtils.consensusSnapshotOf((State)initialState.getState()));
            this.platformCoordinator.consensusSnapshotOverride(consensusSnapshot);
            int roundsNonAncient = ((ConsensusConfig)configuration.getConfigData(ConsensusConfig.class)).roundsNonAncient();
            this.platformCoordinator.updateEventWindow(EventWindowUtils.createEventWindow((ConsensusSnapshot)consensusSnapshot, (int)roundsNonAncient));
            this.platformCoordinator.overrideIssDetectorState(initialState.reserve("initialize issDetector"));
        }
        blocks.getLatestCompleteStateReference().set(() -> latestCompleteStateNexus.getState("get latest complete state for reconnect"));
        blocks.latestImmutableStateProviderReference().set(this.latestImmutableStateNexus::getState);
        this.pcesReplayLowerBound = !initialState.isGenesisState() ? this.initialAncientThreshold : 0L;
    }

    @Override
    @NonNull
    public NodeId getSelfId() {
        return this.selfId;
    }

    @Override
    public void start() {
        logger.info(LogMarker.STARTUP.getMarker(), "Starting platform {}", (Object)this.selfId);
        this.platformContext.getRecycleBin().start();
        this.platformContext.getMetrics().start();
        this.platformCoordinator.start();
        this.replayPreconsensusEvents();
        this.platformCoordinator.startGossip();
    }

    @Override
    public void destroy() throws InterruptedException {
        this.notificationEngine.shutdown();
        this.platformContext.getRecycleBin().stop();
        this.platformCoordinator.stop();
        StaticPlatformBuilder.getMetricsProvider().removePlatformMetrics(this.selfId);
    }

    private void replayPreconsensusEvents() {
        this.platformCoordinator.submitStatusAction(new StartedReplayingEventsAction());
        IOIterator iterator = this.platformComponents.pcesModule().storedEvents(this.pcesReplayLowerBound, this.startingRound);
        logger.info(LogMarker.STARTUP.getMarker(), "replaying preconsensus event stream starting at {}", (Object)this.pcesReplayLowerBound);
        this.platformCoordinator.injectPcesReplayerIterator((IOIterator<PlatformEvent>)iterator);
        this.platformCoordinator.flushStateHasher();
        this.platformCoordinator.signalEndOfPcesReplay();
        this.platformCoordinator.submitStatusAction(new DoneReplayingEventsAction(this.platformContext.getTime().now()));
    }

    @Override
    @NonNull
    public PlatformContext getContext() {
        return this.platformContext;
    }

    @Override
    @NonNull
    public NotificationEngine getNotificationEngine() {
        return this.notificationEngine;
    }

    @Override
    @NonNull
    public Signature sign(@NonNull byte[] data) {
        return new PlatformSigner(this.keysAndCerts).sign(data);
    }

    @Override
    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        this.platformCoordinator.quiescenceCommand(quiescenceCommand);
    }

    @Override
    @NonNull
    public Roster getRoster() {
        return this.currentRoster;
    }

    @Override
    @NonNull
    public <T extends State> AutoCloseableWrapper<T> getLatestImmutableState(@NonNull String reason) {
        ReservedSignedState wrapper = this.latestImmutableStateNexus.getState(reason);
        return wrapper == null ? AutoCloseableWrapper.empty() : new AutoCloseableWrapper((Object)wrapper.get().getState(), () -> ((ReservedSignedState)wrapper).close());
    }
}

