/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli.graph;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.hiero.consensus.event.EventGraphSource;
import org.hiero.consensus.io.RecycleBin;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.pces.impl.common.PcesFileReader;
import org.hiero.consensus.pces.impl.common.PcesFileTracker;
import org.hiero.consensus.pces.impl.common.PcesMultiFileIterator;

public class PcesEventGraphSource
implements EventGraphSource {
    private final PcesMultiFileIterator eventIterator;

    public PcesEventGraphSource(@NonNull Path pcesLocation, @NonNull PlatformContext context) {
        try {
            PcesFileTracker pcesFileTracker = PcesFileReader.readFilesFromDisk((Configuration)context.getConfiguration(), (RecycleBin)context.getRecycleBin(), (Path)pcesLocation, (long)0L, (boolean)false);
            this.eventIterator = pcesFileTracker.getEventIterator(0L, 0L);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error initializing PCES file reader", e);
        }
    }

    @NonNull
    public PlatformEvent next() {
        try {
            return this.eventIterator.next();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading next event from PCES files", e);
        }
    }

    public boolean hasNext() {
        try {
            return this.eventIterator.hasNext();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error checking for next event in PCES files", e);
        }
    }
}

