/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.format;

import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.internal.format.EpochCachedFormatter;
import edu.umd.cs.findbugs.annotations.NonNull;

public class TimestampPrinter {
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    private static final String[] PADDING_VALUES = TimestampPrinter.preparePaddingValues();
    private static final EpochCachedFormatter FORMATTER = new EpochCachedFormatter();
    private static final String BROKEN_TIMESTAMP = "BROKEN-TIMESTAMP";
    private static final int DATE_FIELD_MAX_SIZE = 26;

    private TimestampPrinter() {
    }

    public static void print(@NonNull StringBuilder writer, long timestamp) {
        String format;
        try {
            format = FORMATTER.format(timestamp);
        }
        catch (Throwable e) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to format instant", e);
            format = BROKEN_TIMESTAMP;
        }
        writer.append(format);
        writer.append(PADDING_VALUES[26 - format.length()]);
    }

    @NonNull
    private static String[] preparePaddingValues() {
        String[] fillers = new String[27];
        fillers[0] = "";
        for (int i = 1; i <= 26; ++i) {
            fillers[i] = " ".repeat(i);
        }
        return fillers;
    }
}

