/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.file.FileUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeKeyUtils;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class FileUpdateFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        FileUpdateTransactionBody op = txnBody.fileUpdateOrThrow();
        long keyCount = 0L;
        if (op.hasKeys()) {
            keyCount = txnBody.fileUpdateOrThrow().keys().keys().stream().mapToLong(FeeKeyUtils::countKeys).sum();
        }
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.FILE_UPDATE);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keyCount);
        this.addExtraFee(feeResult, serviceDef, Extra.STATE_BYTES, feeSchedule, op.contents().length());
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.FILE_UPDATE;
    }
}

