/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.TangerineWhistleGasCalculator;
import org.hyperledger.besu.evm.internal.Words;

public class SpuriousDragonGasCalculator
extends TangerineWhistleGasCalculator {
    private static final long EXP_OPERATION_BYTE_GAS_COST = 50L;
    private static final long SELFDESTRUCT_OPERATION_GAS_COST = 5000L;
    private static final long SELFDESTRUCT_OPERATION_CREATES_NEW_ACCOUNT = 30000L;

    @Override
    public long callOperationGasCost(MessageFrame frame, long stipend, long inputDataOffset, long inputDataLength, long outputDataOffset, long outputDataLength, Wei transferValue, Account recipient, Address to, boolean accountIsWarm) {
        long inputDataMemoryExpansionCost = this.memoryExpansionGasCost(frame, inputDataOffset, inputDataLength);
        long outputDataMemoryExpansionCost = this.memoryExpansionGasCost(frame, outputDataOffset, outputDataLength);
        long memoryExpansionCost = Math.max(inputDataMemoryExpansionCost, outputDataMemoryExpansionCost);
        long cost = Words.clampedAdd(this.callOperationBaseGasCost(), memoryExpansionCost);
        if (!transferValue.isZero()) {
            cost = Words.clampedAdd(cost, this.callValueTransferGasCost());
        }
        if ((recipient == null || recipient.isEmpty()) && !transferValue.isZero()) {
            cost = Words.clampedAdd(cost, this.newAccountGasCost());
        }
        return cost;
    }

    @Override
    protected long expOperationByteGasCost() {
        return 50L;
    }

    @Override
    public long selfDestructOperationGasCost(Account recipient, Wei inheritance) {
        if ((recipient == null || recipient.isEmpty()) && !inheritance.isZero()) {
            return 30000L;
        }
        return 5000L;
    }
}

