/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SarOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult sarSuccess = new Operation.OperationResult(3L, null);
    private static final Bytes ALL_BITS = Bytes.fromHexString((CharSequence)"0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");

    public SarOperation(GasCalculator gasCalculator) {
        super(29, "SAR", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return SarOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        boolean negativeNumber;
        Bytes shiftAmount = frame.popStackItem();
        Bytes32 value = Bytes32.leftPad((Bytes)frame.popStackItem());
        boolean bl = negativeNumber = value.get(0) < 0;
        if (shiftAmount.size() > 4 && (shiftAmount = shiftAmount.trimLeadingZeros()).size() > 4) {
            frame.pushStackItem(negativeNumber ? ALL_BITS : Bytes.EMPTY);
        } else {
            int shiftAmountInt = shiftAmount.toInt();
            if (shiftAmountInt >= 256 || shiftAmountInt < 0) {
                frame.pushStackItem(negativeNumber ? ALL_BITS : Bytes.EMPTY);
            } else {
                Bytes result = value.shiftRight(shiftAmountInt);
                if (negativeNumber) {
                    Bytes significantBits = ALL_BITS.shiftLeft(256 - shiftAmountInt);
                    result = result.or(significantBits);
                }
                frame.pushStackItem(result);
            }
        }
        return sarSuccess;
    }
}

