/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.io.extendable;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.hiero.consensus.io.extendable.OutputStreamExtension;

public class ExtendableOutputStream
extends OutputStream {
    private final OutputStream stream;
    private final OutputStreamExtension extension;

    public static OutputStream extendOutputStream(OutputStream stream, OutputStreamExtension ... extensions) {
        if (extensions == null) {
            return stream;
        }
        OutputStream s = stream;
        for (OutputStreamExtension extension : extensions) {
            s = new ExtendableOutputStream(s, extension);
        }
        return s;
    }

    public ExtendableOutputStream(OutputStream stream, OutputStreamExtension extension) {
        this.stream = Objects.requireNonNull(stream, "stream must not be null");
        this.extension = Objects.requireNonNull(extension, "extension must not be null");
        extension.init(stream);
    }

    @Override
    public void write(int b) throws IOException {
        this.extension.write(b);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.extension.write(bytes, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            this.extension.close();
        }
    }
}

