/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli.recovery;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.utility.AutoCloseableNonThrowing;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.system.Platform;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.signed.SignedStateReference;

public class RecoveryPlatform
implements Platform,
AutoCloseableNonThrowing {
    private final NodeId selfId;
    private final Roster roster;
    private final KeysAndCerts keysAndCerts;
    private final SignedStateReference immutableState = new SignedStateReference();
    private final NotificationEngine notificationEngine;
    private final PlatformContext context;

    public RecoveryPlatform(@NonNull Configuration configuration, @NonNull SignedState initialState, @NonNull NodeId selfId, boolean loadSigningKeys) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        Objects.requireNonNull(initialState, "initialState must not be null");
        this.selfId = Objects.requireNonNull(selfId, "selfId must not be null");
        this.roster = initialState.getRoster();
        this.keysAndCerts = loadSigningKeys ? CryptoStatic.initNodeSecurity((Configuration)configuration, (NodeId)selfId, (List)this.roster.rosterEntries()) : null;
        this.notificationEngine = NotificationEngine.buildEngine((ThreadManager)AdHocThreadManager.getStaticThreadManager());
        this.context = PlatformContext.create((Configuration)configuration);
        this.setLatestState(initialState);
    }

    public synchronized void setLatestState(SignedState signedState) {
        this.immutableState.set(signedState, "RecoveryPlatform.setLatestState");
    }

    public Signature sign(byte[] data) {
        if (this.keysAndCerts == null) {
            throw new UnsupportedOperationException("RecoveryPlatform was not loaded with signing keys, this operation is not supported");
        }
        return new PlatformSigner(this.keysAndCerts).sign(data);
    }

    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        throw new UnsupportedOperationException("RecoveryPlatform does not support quiescence status changes");
    }

    @NonNull
    public PlatformContext getContext() {
        return this.context;
    }

    @NonNull
    public NotificationEngine getNotificationEngine() {
        return this.notificationEngine;
    }

    @NonNull
    public Roster getRoster() {
        return this.roster;
    }

    @NonNull
    public NodeId getSelfId() {
        return this.selfId;
    }

    @NonNull
    public <T extends State> AutoCloseableWrapper<T> getLatestImmutableState(@NonNull String reason) {
        ReservedSignedState reservedSignedState = this.immutableState.getAndReserve(reason);
        return new AutoCloseableWrapper((Object)(reservedSignedState.isNull() ? null : reservedSignedState.get().getState()), () -> ((ReservedSignedState)reservedSignedState).close());
    }

    public void close() {
        this.immutableState.clear();
        this.notificationEngine.shutdown();
    }

    public void start() {
    }

    public void destroy() {
        this.close();
    }
}

