/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.fees.FeeAccumulator;
import com.hedera.node.app.service.token.records.FinalizeContext;
import com.hedera.node.app.signature.AppKeyVerifier;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjLongConsumer;

public interface Dispatch
extends FeeCharging.Context {
    public StreamBuilder streamBuilder();

    public Configuration config();

    public Fees fees();

    public TransactionInfo txnInfo();

    public AccountID payerId();

    public ReadableStoreFactory readableStoreFactory();

    public FeeAccumulator feeAccumulator();

    public AppKeyVerifier keyVerifier();

    public NodeInfo creatorInfo();

    public Instant consensusNow();

    public Set<Key> requiredKeys();

    public Set<Account> hollowAccounts();

    public HandleContext handleContext();

    public SavepointStackImpl stack();

    public HandleContext.TransactionCategory txnCategory();

    public FinalizeContext finalizeContext();

    public PreHandleResult preHandleResult();

    public HandleContext.ConsensusThrottling throttleStrategy();

    @Nullable
    public FeeCharging customFeeCharging();

    default public FeeCharging feeChargingOrElse(@NonNull FeeCharging feeCharging) {
        Objects.requireNonNull(feeCharging);
        FeeCharging customFeeCharging = this.customFeeCharging();
        return customFeeCharging != null ? customFeeCharging : feeCharging;
    }

    default public Fees charge(@NonNull AccountID payerId, @NonNull Fees fees, @Nullable ObjLongConsumer<AccountID> cb) {
        return this.feeAccumulator().chargeFee(payerId, fees.totalFee(), cb);
    }

    default public void refund(@NonNull AccountID receiverId, @NonNull Fees fees) {
        Objects.requireNonNull(receiverId);
        Objects.requireNonNull(fees);
        this.feeAccumulator().refundFee(receiverId, fees.totalFee());
    }

    default public Fees charge(@NonNull AccountID payerId, @NonNull Fees fees, @NonNull AccountID nodeAccountId, @Nullable ObjLongConsumer<AccountID> cb) {
        return this.feeAccumulator().chargeFees(payerId, nodeAccountId, fees, cb);
    }

    default public void refund(@NonNull AccountID payerId, @NonNull Fees fees, @NonNull AccountID nodeAccountId) {
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(fees);
        Objects.requireNonNull(nodeAccountId);
        this.feeAccumulator().refundFees(payerId, fees, nodeAccountId);
    }

    default public AccountID nodeAccountId() {
        return this.creatorInfo().accountId();
    }

    default public HandleContext.TransactionCategory category() {
        return this.txnCategory();
    }
}

