/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.record;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.service.token.records.FinalizeContext;
import com.hedera.node.app.service.token.records.TokenContext;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.store.ReadableStoreFactoryImpl;
import com.hedera.node.app.store.WritableStoreFactory;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class TokenContextImpl
implements TokenContext,
FinalizeContext {
    private final Configuration configuration;
    private final ReadableStoreFactory readableStoreFactory;
    private final WritableStoreFactory writableStoreFactory;
    private final Instant consensusTime;
    private final SavepointStackImpl stack;

    public TokenContextImpl(@NonNull Configuration configuration, @NonNull SavepointStackImpl stack, @NonNull Instant consensusTime, @NonNull WritableEntityCounters entityCounters) {
        this.stack = stack;
        Objects.requireNonNull(stack, "stack must not be null");
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.readableStoreFactory = new ReadableStoreFactoryImpl(stack);
        this.writableStoreFactory = new WritableStoreFactory(stack, "TokenService", entityCounters);
        this.consensusTime = Objects.requireNonNull(consensusTime, "consensusTime must not be null");
    }

    @NonNull
    public Instant consensusTime() {
        return this.consensusTime;
    }

    @NonNull
    public Configuration configuration() {
        return this.configuration;
    }

    @NonNull
    public <T> T readableStore(@NonNull Class<T> storeInterface) {
        Objects.requireNonNull(storeInterface, "storeInterface must not be null");
        return (T)this.readableStoreFactory.readableStore(storeInterface);
    }

    @NonNull
    public <T> T writableStore(@NonNull Class<T> storeInterface) {
        Objects.requireNonNull(storeInterface, "storeInterface must not be null");
        return this.writableStoreFactory.getStore(storeInterface);
    }

    @NonNull
    public <T extends StreamBuilder> T userTransactionRecordBuilder(@NonNull Class<T> recordBuilderClass) {
        Objects.requireNonNull(recordBuilderClass, "recordBuilderClass must not be null");
        return this.stack.getBaseBuilder(recordBuilderClass);
    }

    public boolean hasChildOrPrecedingRecords() {
        return this.stack.hasNonBaseStreamBuilder();
    }

    public <T> void forEachChildRecord(@NonNull Class<T> recordBuilderClass, @NonNull Consumer<T> consumer) {
        Objects.requireNonNull(consumer, "consumer must not be null");
        this.stack.forEachNonBaseBuilder(recordBuilderClass, consumer);
    }

    @NonNull
    public <T extends StreamBuilder> T addPrecedingChildRecordBuilder(@NonNull Class<T> recordBuilderClass, @NonNull HederaFunctionality functionality) {
        Objects.requireNonNull(recordBuilderClass);
        Objects.requireNonNull(functionality);
        StreamBuilder result = this.stack.createIrreversiblePrecedingBuilder().functionality(functionality);
        return (T)((StreamBuilder)SavepointStackImpl.castBuilder(result, recordBuilderClass));
    }

    public boolean isScheduleDispatch() {
        return this.stack.txnCategory() == HandleContext.TransactionCategory.SCHEDULED;
    }

    public Set<Long> knownNodeIds() {
        return ((ReadableStakingInfoStore)this.readableStoreFactory.readableStore(ReadableStakingInfoStore.class)).getAll();
    }
}

