/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.data;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.config.types.PermissionedAccountsRange;
import com.swirlds.config.api.ConfigData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Function;

@ConfigData
public record ApiPermissionConfig(PermissionedAccountsRange createAccount, PermissionedAccountsRange cryptoTransfer, PermissionedAccountsRange updateAccount, PermissionedAccountsRange cryptoGetBalance, PermissionedAccountsRange getAccountInfo, PermissionedAccountsRange cryptoDelete, PermissionedAccountsRange getAccountRecords, PermissionedAccountsRange getTxRecordByTxID, PermissionedAccountsRange getTxFastRecordByTxID, PermissionedAccountsRange getTransactionReceipts, PermissionedAccountsRange approveAllowances, PermissionedAccountsRange deleteAllowances, PermissionedAccountsRange utilPrng, PermissionedAccountsRange atomicBatch, PermissionedAccountsRange createFile, PermissionedAccountsRange updateFile, PermissionedAccountsRange deleteFile, PermissionedAccountsRange appendContent, PermissionedAccountsRange getFileContent, PermissionedAccountsRange getFileInfo, PermissionedAccountsRange createContract, PermissionedAccountsRange updateContract, PermissionedAccountsRange contractCallMethod, PermissionedAccountsRange getContractInfo, PermissionedAccountsRange contractCallLocalMethod, PermissionedAccountsRange contractGetBytecode, PermissionedAccountsRange getTxRecordByContractID, PermissionedAccountsRange deleteContract, PermissionedAccountsRange createTopic, PermissionedAccountsRange updateTopic, PermissionedAccountsRange deleteTopic, PermissionedAccountsRange submitMessage, PermissionedAccountsRange getTopicInfo, PermissionedAccountsRange ethereumTransaction, PermissionedAccountsRange scheduleCreate, PermissionedAccountsRange scheduleSign, PermissionedAccountsRange scheduleDelete, PermissionedAccountsRange scheduleGetInfo, PermissionedAccountsRange tokenCreate, PermissionedAccountsRange tokenFreezeAccount, PermissionedAccountsRange tokenUnfreezeAccount, PermissionedAccountsRange tokenGrantKycToAccount, PermissionedAccountsRange tokenRevokeKycFromAccount, PermissionedAccountsRange tokenDelete, PermissionedAccountsRange tokenMint, PermissionedAccountsRange tokenBurn, PermissionedAccountsRange tokenAccountWipe, PermissionedAccountsRange tokenUpdate, PermissionedAccountsRange tokenGetInfo, PermissionedAccountsRange tokenAssociateToAccount, PermissionedAccountsRange tokenDissociateFromAccount, PermissionedAccountsRange tokenGetNftInfo, PermissionedAccountsRange tokenGetNftInfos, PermissionedAccountsRange tokenGetAccountNftInfos, PermissionedAccountsRange tokenFeeScheduleUpdate, PermissionedAccountsRange tokenPause, PermissionedAccountsRange tokenUnpause, PermissionedAccountsRange getVersionInfo, PermissionedAccountsRange networkGetExecutionTime, PermissionedAccountsRange systemDelete, PermissionedAccountsRange systemUndelete, PermissionedAccountsRange freeze, PermissionedAccountsRange getAccountDetails, PermissionedAccountsRange tokenUpdateNfts, PermissionedAccountsRange tokenReject, PermissionedAccountsRange tokenAirdrop, PermissionedAccountsRange tokenCancelAirdrop, PermissionedAccountsRange tokenClaimAirdrop, PermissionedAccountsRange createNode, PermissionedAccountsRange updateNode, PermissionedAccountsRange deleteNode, PermissionedAccountsRange hintsKeyPublication, PermissionedAccountsRange hintsPreprocessingVote, PermissionedAccountsRange hintsPartialSignature, PermissionedAccountsRange tssMessage, PermissionedAccountsRange tssVote, PermissionedAccountsRange tssShareSignature, PermissionedAccountsRange tssEncryptionKey, PermissionedAccountsRange stateSignature, PermissionedAccountsRange historyProofKeyPublication, PermissionedAccountsRange historyAssemblySignature, PermissionedAccountsRange historyProofVote, PermissionedAccountsRange crsPublication, PermissionedAccountsRange lambdaSStore, PermissionedAccountsRange hookStore, PermissionedAccountsRange hookDispatch, PermissionedAccountsRange nodeStakeUpdate, PermissionedAccountsRange ledgerIdPublication, PermissionedAccountsRange createRegisteredNode, PermissionedAccountsRange updateRegisteredNode, PermissionedAccountsRange deleteRegisteredNode) {
    private static final EnumMap<HederaFunctionality, Function<ApiPermissionConfig, PermissionedAccountsRange>> permissionKeys = new EnumMap(HederaFunctionality.class);

    public PermissionedAccountsRange getPermission(@NonNull HederaFunctionality functionality) {
        Objects.requireNonNull(functionality, "functionality cannot be null");
        Function<ApiPermissionConfig, PermissionedAccountsRange> function = permissionKeys.get(functionality);
        if (function == null) {
            throw new IllegalArgumentException("Can not get permission for functionality " + String.valueOf(functionality));
        }
        return function.apply(this);
    }

    static {
        permissionKeys.put(HederaFunctionality.CRYPTO_CREATE, c -> c.createAccount);
        permissionKeys.put(HederaFunctionality.CRYPTO_TRANSFER, c -> c.cryptoTransfer);
        permissionKeys.put(HederaFunctionality.CRYPTO_UPDATE, c -> c.updateAccount);
        permissionKeys.put(HederaFunctionality.CRYPTO_DELETE, c -> c.cryptoDelete);
        permissionKeys.put(HederaFunctionality.CRYPTO_APPROVE_ALLOWANCE, c -> c.approveAllowances);
        permissionKeys.put(HederaFunctionality.CRYPTO_DELETE_ALLOWANCE, c -> c.deleteAllowances);
        permissionKeys.put(HederaFunctionality.FILE_CREATE, c -> c.createFile);
        permissionKeys.put(HederaFunctionality.FILE_UPDATE, c -> c.updateFile);
        permissionKeys.put(HederaFunctionality.FILE_DELETE, c -> c.deleteFile);
        permissionKeys.put(HederaFunctionality.FILE_APPEND, c -> c.appendContent);
        permissionKeys.put(HederaFunctionality.CONTRACT_CREATE, c -> c.createContract);
        permissionKeys.put(HederaFunctionality.CONTRACT_UPDATE, c -> c.updateContract);
        permissionKeys.put(HederaFunctionality.CONTRACT_CALL, c -> c.contractCallMethod);
        permissionKeys.put(HederaFunctionality.CONTRACT_DELETE, c -> c.deleteContract);
        permissionKeys.put(HederaFunctionality.ETHEREUM_TRANSACTION, c -> c.ethereumTransaction);
        permissionKeys.put(HederaFunctionality.LAMBDA_S_STORE, c -> c.lambdaSStore);
        permissionKeys.put(HederaFunctionality.HOOK_STORE, c -> c.hookStore);
        permissionKeys.put(HederaFunctionality.HOOK_DISPATCH, c -> c.hookDispatch);
        permissionKeys.put(HederaFunctionality.CONSENSUS_CREATE_TOPIC, c -> c.createTopic);
        permissionKeys.put(HederaFunctionality.CONSENSUS_UPDATE_TOPIC, c -> c.updateTopic);
        permissionKeys.put(HederaFunctionality.CONSENSUS_DELETE_TOPIC, c -> c.deleteTopic);
        permissionKeys.put(HederaFunctionality.CONSENSUS_SUBMIT_MESSAGE, c -> c.submitMessage);
        permissionKeys.put(HederaFunctionality.TOKEN_CREATE, c -> c.tokenCreate);
        permissionKeys.put(HederaFunctionality.TOKEN_FREEZE_ACCOUNT, c -> c.tokenFreezeAccount);
        permissionKeys.put(HederaFunctionality.TOKEN_UNFREEZE_ACCOUNT, c -> c.tokenUnfreezeAccount);
        permissionKeys.put(HederaFunctionality.TOKEN_GRANT_KYC_TO_ACCOUNT, c -> c.tokenGrantKycToAccount);
        permissionKeys.put(HederaFunctionality.TOKEN_REVOKE_KYC_FROM_ACCOUNT, c -> c.tokenRevokeKycFromAccount);
        permissionKeys.put(HederaFunctionality.TOKEN_DELETE, c -> c.tokenDelete);
        permissionKeys.put(HederaFunctionality.TOKEN_MINT, c -> c.tokenMint);
        permissionKeys.put(HederaFunctionality.TOKEN_BURN, c -> c.tokenBurn);
        permissionKeys.put(HederaFunctionality.TOKEN_ACCOUNT_WIPE, c -> c.tokenAccountWipe);
        permissionKeys.put(HederaFunctionality.TOKEN_UPDATE, c -> c.tokenUpdate);
        permissionKeys.put(HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT, c -> c.tokenAssociateToAccount);
        permissionKeys.put(HederaFunctionality.TOKEN_DISSOCIATE_FROM_ACCOUNT, c -> c.tokenDissociateFromAccount);
        permissionKeys.put(HederaFunctionality.TOKEN_PAUSE, c -> c.tokenPause);
        permissionKeys.put(HederaFunctionality.TOKEN_UNPAUSE, c -> c.tokenUnpause);
        permissionKeys.put(HederaFunctionality.SYSTEM_DELETE, c -> c.systemDelete);
        permissionKeys.put(HederaFunctionality.SYSTEM_UNDELETE, c -> c.systemUndelete);
        permissionKeys.put(HederaFunctionality.FREEZE, c -> c.freeze);
        permissionKeys.put(HederaFunctionality.SCHEDULE_CREATE, c -> c.scheduleCreate);
        permissionKeys.put(HederaFunctionality.SCHEDULE_DELETE, c -> c.scheduleDelete);
        permissionKeys.put(HederaFunctionality.SCHEDULE_SIGN, c -> c.scheduleSign);
        permissionKeys.put(HederaFunctionality.TOKEN_UPDATE_NFTS, c -> c.tokenUpdateNfts);
        permissionKeys.put(HederaFunctionality.TOKEN_REJECT, c -> c.tokenReject);
        permissionKeys.put(HederaFunctionality.TOKEN_AIRDROP, c -> c.tokenAirdrop);
        permissionKeys.put(HederaFunctionality.TOKEN_CANCEL_AIRDROP, c -> c.tokenCancelAirdrop);
        permissionKeys.put(HederaFunctionality.TOKEN_CLAIM_AIRDROP, c -> c.tokenClaimAirdrop);
        permissionKeys.put(HederaFunctionality.CONSENSUS_GET_TOPIC_INFO, c -> c.getTopicInfo);
        permissionKeys.put(HederaFunctionality.CONTRACT_CALL_LOCAL, c -> c.contractCallLocalMethod);
        permissionKeys.put(HederaFunctionality.CONTRACT_GET_INFO, c -> c.getContractInfo);
        permissionKeys.put(HederaFunctionality.CONTRACT_GET_BYTECODE, c -> c.contractGetBytecode);
        permissionKeys.put(HederaFunctionality.CONTRACT_GET_RECORDS, c -> c.getTxRecordByContractID);
        permissionKeys.put(HederaFunctionality.CRYPTO_GET_ACCOUNT_BALANCE, c -> c.cryptoGetBalance);
        permissionKeys.put(HederaFunctionality.CRYPTO_GET_ACCOUNT_RECORDS, c -> c.getAccountRecords);
        permissionKeys.put(HederaFunctionality.CRYPTO_GET_INFO, c -> c.getAccountInfo);
        permissionKeys.put(HederaFunctionality.FILE_GET_CONTENTS, c -> c.getFileContent);
        permissionKeys.put(HederaFunctionality.FILE_GET_INFO, c -> c.getFileInfo);
        permissionKeys.put(HederaFunctionality.TRANSACTION_GET_RECEIPT, c -> c.getTransactionReceipts);
        permissionKeys.put(HederaFunctionality.TRANSACTION_GET_RECORD, c -> c.getTxRecordByTxID);
        permissionKeys.put(HederaFunctionality.TRANSACTION_GET_FAST_RECORD, c -> c.getTxFastRecordByTxID);
        permissionKeys.put(HederaFunctionality.GET_VERSION_INFO, c -> c.getVersionInfo);
        permissionKeys.put(HederaFunctionality.NETWORK_GET_EXECUTION_TIME, c -> c.networkGetExecutionTime);
        permissionKeys.put(HederaFunctionality.GET_ACCOUNT_DETAILS, c -> c.getAccountDetails);
        permissionKeys.put(HederaFunctionality.TOKEN_GET_INFO, c -> c.tokenGetInfo);
        permissionKeys.put(HederaFunctionality.SCHEDULE_GET_INFO, c -> c.scheduleGetInfo);
        permissionKeys.put(HederaFunctionality.TOKEN_GET_NFT_INFO, c -> c.tokenGetNftInfo);
        permissionKeys.put(HederaFunctionality.TOKEN_GET_NFT_INFOS, c -> c.tokenGetNftInfos);
        permissionKeys.put(HederaFunctionality.TOKEN_GET_ACCOUNT_NFT_INFOS, c -> c.tokenGetAccountNftInfos);
        permissionKeys.put(HederaFunctionality.TOKEN_FEE_SCHEDULE_UPDATE, c -> c.tokenFeeScheduleUpdate);
        permissionKeys.put(HederaFunctionality.UTIL_PRNG, c -> c.utilPrng);
        permissionKeys.put(HederaFunctionality.ATOMIC_BATCH, c -> c.atomicBatch);
        permissionKeys.put(HederaFunctionality.NODE_CREATE, c -> c.createNode);
        permissionKeys.put(HederaFunctionality.NODE_UPDATE, c -> c.updateNode);
        permissionKeys.put(HederaFunctionality.NODE_DELETE, c -> c.deleteNode);
        permissionKeys.put(HederaFunctionality.STATE_SIGNATURE_TRANSACTION, c -> c.stateSignature);
        permissionKeys.put(HederaFunctionality.HINTS_KEY_PUBLICATION, c -> c.hintsKeyPublication);
        permissionKeys.put(HederaFunctionality.HINTS_PREPROCESSING_VOTE, c -> c.hintsPreprocessingVote);
        permissionKeys.put(HederaFunctionality.HINTS_PARTIAL_SIGNATURE, c -> c.hintsPartialSignature);
        permissionKeys.put(HederaFunctionality.HISTORY_PROOF_KEY_PUBLICATION, c -> c.historyProofKeyPublication);
        permissionKeys.put(HederaFunctionality.HISTORY_ASSEMBLY_SIGNATURE, c -> c.historyAssemblySignature);
        permissionKeys.put(HederaFunctionality.HISTORY_PROOF_VOTE, c -> c.historyProofVote);
        permissionKeys.put(HederaFunctionality.CRS_PUBLICATION, c -> c.crsPublication);
        permissionKeys.put(HederaFunctionality.NODE_STAKE_UPDATE, c -> c.nodeStakeUpdate);
        permissionKeys.put(HederaFunctionality.LEDGER_ID_PUBLICATION, c -> c.ledgerIdPublication);
        permissionKeys.put(HederaFunctionality.REGISTERED_NODE_CREATE, c -> c.createRegisteredNode);
        permissionKeys.put(HederaFunctionality.REGISTERED_NODE_UPDATE, c -> c.updateRegisteredNode);
        permissionKeys.put(HederaFunctionality.REGISTERED_NODE_DELETE, c -> c.deleteRegisteredNode);
    }
}

