/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;

final class BytesValues {
    static final int MAX_UNSIGNED_SHORT = 65535;
    static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    static final long MAX_UNSIGNED_LONG = Long.MAX_VALUE;

    private BytesValues() {
    }

    static Bytes fromHexString(CharSequence str, int destSize, boolean lenient) {
        return Bytes.wrap(BytesValues.fromRawHexString(str, destSize, lenient));
    }

    static byte[] fromRawHexString(CharSequence str, int destSize, boolean lenient) {
        int destOffset;
        int len = str.length();
        Object hex = str;
        if (len >= 2 && str.charAt(0) == '0' && str.charAt(1) == 'x') {
            hex = str.subSequence(2, len);
            len -= 2;
        }
        int idxShift = 0;
        if ((len & 1) != 0) {
            if (!lenient) {
                throw new IllegalArgumentException("Invalid odd-length hex binary representation");
            }
            hex = "0" + (CharSequence)hex;
            ++len;
            idxShift = 1;
        }
        int size = len >> 1;
        if (destSize < 0) {
            destSize = size;
        } else {
            Checks.checkArgument(size <= destSize, "Hex value is too large: expected at most %s bytes but got %s", destSize, size);
        }
        byte[] out = new byte[destSize];
        int i = destOffset = destSize - size;
        int j = 0;
        while (j < len) {
            int l;
            int h = Character.digit(hex.charAt(j), 16);
            if (h == -1) {
                throw new IllegalArgumentException(String.format("Illegal character '%c' found at index %d in hex binary representation", Character.valueOf(hex.charAt(j)), j - idxShift));
            }
            if ((l = Character.digit(hex.charAt(++j), 16)) == -1) {
                throw new IllegalArgumentException(String.format("Illegal character '%c' found at index %d in hex binary representation", Character.valueOf(hex.charAt(j)), j - idxShift));
            }
            ++j;
            out[i] = (byte)((h << 4) + l);
            ++i;
        }
        return out;
    }
}

