/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.entities.TokenEntitySizes;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenCreateMeta;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.CustomFeesValidator;
import com.hedera.node.app.service.token.impl.validators.TokenCreateValidator;
import com.hedera.node.app.service.token.records.TokenCreateStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenCreateHandler
extends BaseTokenHandler
implements TransactionHandler {
    private final EntityIdFactory idFactory;
    private final CustomFeesValidator customFeesValidator;
    private final TokenCreateValidator tokenCreateValidator;

    @Inject
    public TokenCreateHandler(@NonNull EntityIdFactory idFactory, @NonNull CustomFeesValidator customFeesValidator, @NonNull TokenCreateValidator tokenCreateValidator) {
        this.idFactory = Objects.requireNonNull(idFactory);
        this.customFeesValidator = Objects.requireNonNull(customFeesValidator);
        this.tokenCreateValidator = Objects.requireNonNull(tokenCreateValidator);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenCreateTransactionBody tokenCreateTxnBody = txn.tokenCreationOrThrow();
        if (tokenCreateTxnBody.hasTreasury()) {
            AccountID treasuryId = tokenCreateTxnBody.treasuryOrThrow();
            context.requireKeyOrThrow(treasuryId, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (tokenCreateTxnBody.hasAutoRenewAccount()) {
            AccountID autoRenewalAccountId = tokenCreateTxnBody.autoRenewAccountOrThrow();
            context.requireKeyOrThrow(autoRenewalAccountId, ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
        if (tokenCreateTxnBody.hasAdminKey()) {
            context.requireKey(tokenCreateTxnBody.adminKeyOrThrow());
        }
        List customFees = tokenCreateTxnBody.customFees();
        this.addCustomFeeCollectorKeys(context, customFees);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        this.tokenCreateValidator.pureChecks(txn.tokenCreationOrThrow());
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenCreateTransactionBody op = txn.tokenCreationOrThrow();
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        StoreFactory storeFactory = context.storeFactory();
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableTokenRelationStore tokenRelationStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        TokenCreateStreamBuilder recordBuilder = (TokenCreateStreamBuilder)context.savepointStack().getBaseBuilder(TokenCreateStreamBuilder.class);
        HandleException.validateTrue((tokenStore.sizeOfState() + 1L <= tokensConfig.maxNumber() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        ExpiryMeta resolvedExpiryMeta = this.validateSemantics(context, accountStore, op, tokensConfig);
        long newTokenNum = context.entityNumGenerator().newEntityNum();
        TokenID newTokenId = this.idFactory.newTokenId(newTokenNum);
        Token newToken = this.buildToken(newTokenId, op, resolvedExpiryMeta);
        List<CustomFee> feesSetNeedingCollectorAutoAssociation = this.customFeesValidator.validateForCreation(newToken, accountStore, tokenRelationStore, tokenStore, op.customFees(), context.expiryValidator());
        tokenStore.putAndIncrementCount(newToken);
        this.associateAccounts(context, newToken, accountStore, tokenRelationStore, feesSetNeedingCollectorAutoAssociation, recordBuilder);
        TokenRelation treasuryRel = Objects.requireNonNull(tokenRelationStore.get(op.treasuryOrThrow(), newTokenId));
        if (op.initialSupply() > 0L) {
            this.mintFungible(newToken, treasuryRel, op.initialSupply(), accountStore, tokenStore, tokenRelationStore, context.expiryValidator());
        }
        Account treasuryAccount = Objects.requireNonNull(accountStore.get(treasuryRel.accountIdOrThrow()));
        accountStore.put(treasuryAccount.copyBuilder().numberTreasuryTitles(treasuryAccount.numberTreasuryTitles() + 1).build());
        recordBuilder.tokenID(newTokenId);
        recordBuilder.tokenType(newToken.tokenType());
    }

    private void associateAccounts(HandleContext context, Token newToken, WritableAccountStore accountStore, @NonNull WritableTokenRelationStore tokenRelStore, List<CustomFee> requireCollectorAutoAssociation, TokenCreateStreamBuilder recordBuilder) {
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        EntitiesConfig entitiesConfig = (EntitiesConfig)context.configuration().getConfigData(EntitiesConfig.class);
        Account treasury = accountStore.get(newToken.treasuryAccountId());
        this.tokenCreateValidator.validateAssociation(entitiesConfig, tokensConfig, treasury, newToken, tokenRelStore);
        this.createAndLinkTokenRels(treasury, List.of(newToken), accountStore, tokenRelStore);
        recordBuilder.addAutomaticTokenAssociation(TokenCreateHandler.asTokenAssociation(newToken.tokenId(), treasury.accountId()));
        for (CustomFee customFee : requireCollectorAutoAssociation) {
            TokenRelation existingTokenRel;
            Account collector = accountStore.get(customFee.feeCollectorAccountIdOrThrow());
            if (treasury.accountId().equals((Object)collector.accountId()) || (existingTokenRel = tokenRelStore.get(collector.accountId(), newToken.tokenId())) != null) continue;
            this.tokenCreateValidator.validateAssociation(entitiesConfig, tokensConfig, collector, newToken, tokenRelStore);
            this.createAndLinkTokenRels(collector, List.of(newToken), accountStore, tokenRelStore);
            recordBuilder.addAutomaticTokenAssociation(TokenCreateHandler.asTokenAssociation(newToken.tokenId(), collector.accountId()));
        }
    }

    private Token buildToken(TokenID newTokenId, TokenCreateTransactionBody op, ExpiryMeta resolvedExpiryMeta) {
        return new Token(newTokenId, op.name(), op.symbol(), op.decimals(), 0L, op.treasury(), op.adminKey(), op.kycKey(), op.freezeKey(), op.wipeKey(), op.supplyKey(), op.feeScheduleKey(), op.pauseKey(), 0L, false, op.tokenType(), op.supplyType(), resolvedExpiryMeta.autoRenewAccountId(), resolvedExpiryMeta.hasAutoRenewPeriod() ? resolvedExpiryMeta.autoRenewPeriod() : 0L, resolvedExpiryMeta.expiry(), op.memo(), op.maxSupply(), false, op.freezeDefault(), false, this.modifyCustomFeesWithSentinelValues(op.customFees(), newTokenId), op.metadata(), op.metadataKey());
    }

    private List<CustomFee> modifyCustomFeesWithSentinelValues(List<CustomFee> customFees, TokenID newTokenId) {
        return customFees.stream().map(fee -> {
            if (fee.hasFixedFee() && fee.fixedFeeOrThrow().hasDenominatingTokenId() && fee.fixedFeeOrThrow().denominatingTokenIdOrThrow().equals((Object)CustomFeesValidator.SENTINEL_TOKEN_ID)) {
                FixedFee modifiedFixedFee = fee.fixedFeeOrThrow().copyBuilder().denominatingTokenId(newTokenId).build();
                return fee.copyBuilder().fixedFee(modifiedFixedFee).build();
            }
            return fee;
        }).toList();
    }

    private ExpiryMeta getExpiryMeta(@NonNull TokenCreateTransactionBody op) {
        long impliedExpiry = op.hasExpiry() ? op.expiry().seconds() : ExpiryMeta.NA;
        return new ExpiryMeta(impliedExpiry, op.hasAutoRenewPeriod() ? op.autoRenewPeriod().seconds() : ExpiryMeta.NA, op.autoRenewAccount());
    }

    private ExpiryMeta validateSemantics(@NonNull HandleContext context, @NonNull ReadableAccountStore accountStore, @NonNull TokenCreateTransactionBody op, @NonNull TokensConfig config) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(op);
        Objects.requireNonNull(config);
        this.tokenCreateValidator.validate(context, accountStore, op, config);
        ExpiryMeta givenExpiryMeta = this.getExpiryMeta(op);
        ExpiryMeta resolvedExpiryMeta = context.expiryValidator().resolveCreationAttempt(false, givenExpiryMeta, HederaFunctionality.TOKEN_CREATE);
        if (resolvedExpiryMeta.hasAutoRenewAccountId()) {
            TokenHandlerHelper.getIfUsableForAutoRenew(resolvedExpiryMeta.autoRenewAccountId(), accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
        return resolvedExpiryMeta;
    }

    private void addCustomFeeCollectorKeys(@NonNull PreHandleContext context, @NonNull List<CustomFee> customFeesList) throws PreCheckException {
        for (CustomFee customFee : customFeesList) {
            boolean alwaysAdd;
            AccountID collector = customFee.feeCollectorAccountIdOrElse(AccountID.DEFAULT);
            ReadableAccountStore acctStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
            Account collectorAcct = acctStore.getAccountById(collector);
            if (collectorAcct != null && (collectorAcct.alias() == null || Bytes.EMPTY.equals((Object)collectorAcct.alias())) && collectorAcct.hasKey()) {
                TokenHandlerHelper.verifyNotEmptyKey(collectorAcct.key(), ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
            }
            if (customFee.hasFixedFee()) {
                FixedFee fixedFee = customFee.fixedFeeOrThrow();
                alwaysAdd = fixedFee.hasDenominatingTokenId() && fixedFee.denominatingTokenIdOrThrow().tokenNum() == 0L;
                this.addAccount(context, collector, alwaysAdd);
                continue;
            }
            if (customFee.hasFractionalFee()) {
                context.requireKeyOrThrow(collector, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
                continue;
            }
            if (!customFee.hasRoyaltyFee()) continue;
            RoyaltyFee royaltyFee = customFee.royaltyFeeOrThrow();
            alwaysAdd = false;
            if (royaltyFee.hasFallbackFee()) {
                FixedFee fFee = royaltyFee.fallbackFeeOrThrow();
                alwaysAdd = fFee.hasDenominatingTokenId() && fFee.denominatingTokenIdOrThrow().tokenNum() == 0L;
            }
            this.addAccount(context, collector, alwaysAdd);
        }
    }

    private void addAccount(@NonNull PreHandleContext context, @NonNull AccountID collector, boolean alwaysAdd) throws PreCheckException {
        if (alwaysAdd) {
            context.requireKeyOrThrow(collector, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
        } else {
            context.requireKeyIfReceiverSigRequired(collector, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        TokenCreateMeta meta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenCreateUsageFrom(CommonPbjConverters.fromPbj((TransactionBody)body));
        TokenCreateTransactionBody op = body.tokenCreationOrThrow();
        TokenType type = op.tokenType();
        long tokenSizes = (long)TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(meta.getNumTokens(), meta.getFungibleNumTransfers(), meta.getNftsTransfers()) * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs();
        return feeContext.feeCalculatorFactory().feeCalculator(TokenCreateHandler.tokenSubTypeFrom(type, op.hasFeeScheduleKey() || !op.customFees().isEmpty())).addBytesPerTransaction((long)meta.getBaseSize()).addRamByteSeconds(tokenSizes).addNetworkRamByteSeconds(meta.getNetworkRecordRb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs()).addRamByteSeconds((long)(meta.getBaseSize() + meta.getCustomFeeScheduleSize()) * meta.getLifeTime()).calculate();
    }

    public static SubType tokenSubTypeFrom(TokenType tokenType, boolean hasCustomFees) {
        return switch (tokenType) {
            default -> throw new MatchException(null, null);
            case TokenType.UNRECOGNIZED -> throw new IllegalArgumentException("Unrecognized token type");
            case TokenType.FUNGIBLE_COMMON -> {
                if (hasCustomFees) {
                    yield SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
                }
                yield SubType.TOKEN_FUNGIBLE_COMMON;
            }
            case TokenType.NON_FUNGIBLE_UNIQUE -> hasCustomFees ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES : SubType.TOKEN_NON_FUNGIBLE_UNIQUE;
        };
    }
}

