/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.codec.HashObjectJsonCodec;
import com.hedera.hapi.streams.codec.HashObjectProtoCodec;
import com.hedera.hapi.streams.schema.HashObjectSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;

public final class HashObject {
    public static final Codec<HashObject> PROTOBUF = new HashObjectProtoCodec();
    public static final JsonCodec<HashObject> JSON = new HashObjectJsonCodec();
    public static final HashObject DEFAULT = HashObject.newBuilder().build();
    private final Object algorithm;
    private final int length;
    @NonNull
    private final Bytes hash;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public HashObject(HashAlgorithm algorithm, int length, Bytes hash) {
        this.$unknownFields = null;
        this.algorithm = algorithm;
        this.length = length;
        this.hash = hash != null ? hash : Bytes.EMPTY;
    }

    public HashObject(Object algorithm, int length, Bytes hash) {
        this.$unknownFields = null;
        this.algorithm = algorithm;
        this.length = length;
        this.hash = hash != null ? hash : Bytes.EMPTY;
    }

    public HashObject(HashAlgorithm algorithm, int length, Bytes hash, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.algorithm = algorithm;
        this.length = length;
        this.hash = hash != null ? hash : Bytes.EMPTY;
    }

    public HashObject(Object algorithm, int length, Bytes hash, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.algorithm = algorithm;
        this.length = length;
        this.hash = hash != null ? hash : Bytes.EMPTY;
    }

    public HashAlgorithm algorithm() {
        return HashAlgorithm.fromObject(this.algorithm);
    }

    public int algorithmProtoOrdinal() {
        return HashAlgorithm.toProtoOrdinal(this.algorithm);
    }

    public int length() {
        return this.length;
    }

    public Bytes hash() {
        return this.hash;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)HashObjectSchema.ALGORITHM, (Object)this.algorithm);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)HashObjectSchema.LENGTH, (int)this.length, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)HashObjectSchema.HASH, (RandomAccessData)this.hash, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.algorithm != null && !this.algorithm.equals(HashObject.DEFAULT.algorithm)) {
                result = 31 * result + Integer.hashCode(EnumWithProtoMetadata.protoOrdinal((Object)this.algorithm));
            }
            if (this.length != HashObject.DEFAULT.length) {
                result = 31 * result + Integer.hashCode(this.length);
            }
            if (this.hash != null && !this.hash.equals((Object)HashObject.DEFAULT.hash)) {
                result = 31 * result + this.hash.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        HashObject thatObj = (HashObject)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.algorithm == null && thatObj.algorithm != null) {
            return false;
        }
        if (this.algorithm != null && !this.algorithm.equals(thatObj.algorithm)) {
            return false;
        }
        if (this.length != thatObj.length) {
            return false;
        }
        if (this.hash == null && thatObj.hash != null) {
            return false;
        }
        if (this.hash != null && !this.hash.equals((Object)thatObj.hash)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "HashObject[algorithm=" + String.valueOf(this.algorithm) + ", length=" + this.length + ", hash=" + String.valueOf(this.hash) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public Builder copyBuilder() {
        return new Builder(this.algorithm, this.length, this.hash, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Object algorithm = HashAlgorithm.fromProtobufOrdinal(0);
        private int length = 0;
        @NonNull
        private Bytes hash = Bytes.EMPTY;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(HashAlgorithm algorithm, int length, Bytes hash) {
            this.$unknownFields = null;
            this.algorithm = algorithm;
            this.length = length;
            this.hash = hash != null ? hash : Bytes.EMPTY;
        }

        public Builder(Object algorithm, int length, Bytes hash) {
            this.$unknownFields = null;
            this.algorithm = algorithm;
            this.length = length;
            this.hash = hash != null ? hash : Bytes.EMPTY;
        }

        public Builder(HashAlgorithm algorithm, int length, Bytes hash, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.algorithm = algorithm;
            this.length = length;
            this.hash = hash != null ? hash : Bytes.EMPTY;
        }

        public Builder(Object algorithm, int length, Bytes hash, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.algorithm = algorithm;
            this.length = length;
            this.hash = hash != null ? hash : Bytes.EMPTY;
        }

        public HashObject build() {
            return new HashObject(this.algorithm, this.length, this.hash);
        }

        public Builder algorithm(HashAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder hash(@NonNull Bytes hash) {
            this.hash = hash != null ? hash : Bytes.EMPTY;
            return this;
        }

        public HashAlgorithm algorithm() {
            return HashAlgorithm.fromObject(this.algorithm);
        }

        public int algorithmProtoOrdinal() {
            return HashAlgorithm.toProtoOrdinal(this.algorithm);
        }

        public int length() {
            return this.length;
        }

        public Bytes hash() {
            return this.hash;
        }
    }
}

