/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import java.math.BigInteger;
import java.util.Arrays;
import org.hyperledger.besu.crypto.altbn128.AltBn128Fq12Point;
import org.hyperledger.besu.crypto.altbn128.AltBn128Fq2Point;
import org.hyperledger.besu.crypto.altbn128.AltBn128Point;
import org.hyperledger.besu.crypto.altbn128.FieldElement;
import org.hyperledger.besu.crypto.altbn128.Fq;
import org.hyperledger.besu.crypto.altbn128.Fq12;

public class AltBn128Fq12Pairer {
    private static final int LOG_ATE_LOOP_COUNT = 63;
    private static final BigInteger ATE_LOOP_COUNT = new BigInteger("29793968203157093288");
    private static final BigInteger CURVE_ORDER = new BigInteger("21888242871839275222246405745257275088548364400416034343698204186575808495617");

    private AltBn128Fq12Pairer() {
    }

    public static Fq12 pair(AltBn128Point p, AltBn128Fq2Point q) {
        return AltBn128Fq12Pairer.millerLoop(AltBn128Fq12Pairer.cast(p), AltBn128Fq12Point.twist(q));
    }

    private static AltBn128Fq12Point cast(AltBn128Point p) {
        Object[] newX = new Fq[12];
        Arrays.fill(newX, Fq.zero());
        newX[0] = p.getX();
        Object[] newY = new Fq[12];
        Arrays.fill(newY, Fq.zero());
        newY[0] = p.getY();
        return new AltBn128Fq12Point(new Fq12((Fq[])newX), new Fq12((Fq[])newY));
    }

    private static Fq12 millerLoop(AltBn128Fq12Point p, AltBn128Fq12Point q) {
        if (p.isInfinity() || q.isInfinity()) {
            return Fq12.one();
        }
        AltBn128Fq12Point r = q;
        Fq12 f = Fq12.one();
        for (int i = 63; i >= 0; --i) {
            f = f.multiply(f).multiply(AltBn128Fq12Pairer.lineFunc(r, r, p));
            r = (AltBn128Fq12Point)r.doub();
            if (!ATE_LOOP_COUNT.testBit(i)) continue;
            f = f.multiply(AltBn128Fq12Pairer.lineFunc(r, q, p));
            r = r.add(q);
        }
        AltBn128Fq12Point q1 = new AltBn128Fq12Point((Fq12)q.getX().power(FieldElement.FIELD_MODULUS), (Fq12)q.getY().power(FieldElement.FIELD_MODULUS));
        AltBn128Fq12Point nQ2 = new AltBn128Fq12Point((Fq12)q1.getX().power(FieldElement.FIELD_MODULUS), (Fq12)((Fq12)q1.getY().negate()).power(FieldElement.FIELD_MODULUS));
        f = f.multiply(AltBn128Fq12Pairer.lineFunc(r, q1, p));
        r = r.add(q1);
        f = f.multiply(AltBn128Fq12Pairer.lineFunc(r, nQ2, p));
        return f;
    }

    public static Fq12 finalize(Fq12 f) {
        return (Fq12)f.power(FieldElement.FIELD_MODULUS.pow(12).subtract(BigInteger.ONE).divide(CURVE_ORDER));
    }

    private static Fq12 lineFunc(AltBn128Fq12Point p1, AltBn128Fq12Point p2, AltBn128Fq12Point t) {
        Fq12 x1 = p1.getX();
        Fq12 y1 = p1.getY();
        Fq12 x2 = p2.getX();
        Fq12 y2 = p2.getY();
        Fq12 xT = t.getX();
        Fq12 yT = t.getY();
        if (!x1.equals(x2)) {
            Fq12 m = y2.subtract(y1).divide(x2.subtract(x1));
            Fq12 result = m.multiply(xT.subtract(x1)).subtract(yT.subtract(y1));
            return result;
        }
        if (y1.equals(y2)) {
            Fq12 m = ((Fq12)((Fq12)x1.power(2)).multiply(3)).divide((Fq12)y1.multiply(2));
            Fq12 result = m.multiply(xT.subtract(x1)).subtract(yT.subtract(y1));
            return result;
        }
        return xT.subtract(x1);
    }
}

