/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.metrics;

import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.metrics.RunningAverageMetric;

public record CountAccumulateAverageMetricTriplet(Counter counter, LongAccumulator accumulator, RunningAverageMetric average) {
    private static final String AVERAGE_SUFFIX = "_avg";
    private static final String COUNT_SUFFIX = "_count";
    private static final String ACCUMULATOR_SUFFIX = "_sum";

    public static CountAccumulateAverageMetricTriplet create(@NonNull Metrics metrics, @NonNull String category, @NonNull String baseName, @NonNull String baseDescription) {
        RunningAverageMetric.Config averageConfig = new RunningAverageMetric.Config(category, baseName + AVERAGE_SUFFIX).withDescription(baseDescription + " (running average)").withFormat("%,10.6f");
        Counter.Config counterConfig = new Counter.Config(category, baseName + COUNT_SUFFIX).withDescription(baseDescription + " (observation count)");
        LongAccumulator.Config accumulatorConfig = new LongAccumulator.Config(category, baseName + ACCUMULATOR_SUFFIX).withDescription(baseDescription + " (sum)").withAccumulator(Long::sum);
        return new CountAccumulateAverageMetricTriplet((Counter)metrics.getOrCreate((MetricConfig)counterConfig), (LongAccumulator)metrics.getOrCreate((MetricConfig)accumulatorConfig), (RunningAverageMetric)metrics.getOrCreate((MetricConfig)averageConfig));
    }

    public void recordObservation(long value) {
        this.counter.increment();
        this.accumulator.update(value);
        this.average.update((double)value);
    }
}

