/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenuri;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.hapi.utils.HederaExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenuri.TokenUriTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class TokenUriCall
extends AbstractCall {
    public static final String URI_QUERY_NON_EXISTING_TOKEN_ERROR = "ERC721Metadata: URI query for nonexistent token";
    private final long serialNo;
    @Nullable
    private final Token token;

    public TokenUriCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token, long serialNo) {
        super(gasCalculator, enhancement, true);
        this.token = token;
        this.serialNo = serialNo;
    }

    @Override
    public boolean allowsStaticFrame() {
        return true;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(MessageFrame frame) {
        String metadata = URI_QUERY_NON_EXISTING_TOKEN_ERROR;
        if (this.token != null) {
            if (this.token.tokenType() == TokenType.FUNGIBLE_COMMON) {
                return Call.PricedResult.gasOnly(FullResult.haltResult(HederaExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_TOKEN_ID, false);
            }
            Nft nft = this.nativeOperations().getNft(this.token.tokenIdOrThrow(), this.serialNo);
            if (nft != null) {
                metadata = new String(nft.metadata().toByteArray());
            }
        }
        return Call.PricedResult.gasOnly(FullResult.successResult(TokenUriTranslator.TOKEN_URI.getOutputs().encode((Object)Tuple.singleton((Object)metadata)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
    }
}

