/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.exports;

import com.hedera.node.app.hapi.utils.exports.FileCompressionUtils;
import com.hedera.services.stream.proto.RecordStreamFile;
import com.swirlds.common.io.utility.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;

public class RecordBlockNumberTool {
    private static final String LOG_CONFIG_PROPERTY = "logConfig";
    private static final String FILE_NAME_PROPERTY = "fileName";
    private static final String DIR_PROPERTY = "dir";
    private static final Logger LOGGER = LogManager.getLogger(RecordBlockNumberTool.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"BLOCK_NUMBER");
    private static final String DEFAULT_LOG_CONFIG = "log4j2.xml";
    private static final String RECORD_STREAM_EXTENSION = "rcd";
    private static final String COMPRESSED_RECORD_STREAM_EXTENSION = "rcd.gz";
    private static long prevBlockNumber = -1L;

    private RecordBlockNumberTool() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void prepare() throws ConstructableRegistryException {
        ConstructableRegistry registry = ConstructableRegistry.getInstance();
        registry.registerConstructables("com.swirlds.common");
        registry.registerConstructables("org.hiero");
        LOGGER.info(MARKER, "registering Constructables for parsing record stream files");
        registry.registerConstructables("com.hedera.services.stream");
    }

    private static Pair<Integer, Optional<RecordStreamFile>> readMaybeCompressedRecordStreamFile(String loc) throws IOException {
        boolean isCompressed = loc.endsWith(COMPRESSED_RECORD_STREAM_EXTENSION);
        return isCompressed ? RecordBlockNumberTool.readRecordStreamFile(loc) : RecordBlockNumberTool.readUncompressedRecordStreamFile(loc);
    }

    private static Pair<Integer, Optional<RecordStreamFile>> readUncompressedRecordStreamFile(String fileLoc) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileLoc);){
            int recordFileVersion = ByteBuffer.wrap(fin.readNBytes(4)).getInt();
            RecordStreamFile recordStreamFile = RecordStreamFile.parseFrom((InputStream)fin);
            Pair pair = Pair.of((Object)recordFileVersion, Optional.ofNullable(recordStreamFile));
            return pair;
        }
    }

    private static Pair<Integer, Optional<RecordStreamFile>> readRecordStreamFile(String fileLoc) throws IOException {
        Path parent = Path.of(fileLoc, new String[0]).toAbsolutePath().normalize().getParent();
        Path authorizedDir = parent == null ? Path.of("", new String[0]).toAbsolutePath() : parent;
        byte[] uncompressedFileContents = FileCompressionUtils.readUncompressedFileBytes(authorizedDir, fileLoc);
        int recordFileVersion = ByteBuffer.wrap(uncompressedFileContents, 0, 4).getInt();
        RecordStreamFile recordStreamFile = RecordStreamFile.parseFrom((ByteBuffer)ByteBuffer.wrap(uncompressedFileContents, 4, uncompressedFileContents.length - 4));
        return Pair.of((Object)recordFileVersion, Optional.ofNullable(recordStreamFile));
    }

    private static void trackBlockNumber(long currentBlockNumber) {
        if (currentBlockNumber <= prevBlockNumber) {
            LOGGER.error(MARKER, "Found new block number is equal or less than the previous one, current {} vs prev {}", (Object)currentBlockNumber, (Object)prevBlockNumber);
        }
        if (prevBlockNumber != 0L && currentBlockNumber - prevBlockNumber > 1L) {
            LOGGER.error(MARKER, "Found a gap between block numbers: current {} vs prev {}", (Object)currentBlockNumber, (Object)prevBlockNumber);
        }
        LOGGER.info(MARKER, "Block number = {}", (Object)currentBlockNumber);
        prevBlockNumber = currentBlockNumber;
    }

    private static Pair<byte[], byte[]> readRecordFile(String recordFile) {
        try {
            Pair<Integer, Optional<RecordStreamFile>> recordResult = RecordBlockNumberTool.readMaybeCompressedRecordStreamFile(recordFile);
            if (((Optional)recordResult.getValue()).isEmpty()) {
                throw new RuntimeException("Record result is empty");
            }
            long blockNumber = ((RecordStreamFile)((Optional)recordResult.getValue()).get()).getBlockNumber();
            RecordBlockNumberTool.trackBlockNumber(blockNumber);
            byte[] startRunningHash = ((RecordStreamFile)((Optional)recordResult.getValue()).get()).getStartObjectRunningHash().getHash().toByteArray();
            byte[] endRunningHash = ((RecordStreamFile)((Optional)recordResult.getValue()).get()).getEndObjectRunningHash().getHash().toByteArray();
            return Pair.of((Object)startRunningHash, (Object)endRunningHash);
        }
        catch (IOException e) {
            Thread.currentThread().interrupt();
            LOGGER.error(MARKER, "Got IOException when reading record file {} : {}", (Object)recordFile, (Object)e);
            return Pair.of(null, null);
        }
    }

    public static void main(String[] args) {
        block7: {
            File logConfigFile;
            try {
                RecordBlockNumberTool.prepare();
            }
            catch (ConstructableRegistryException e) {
                LOGGER.error(MARKER, "fail to register constructables.", (Throwable)e);
                return;
            }
            String logConfigPath = System.getProperty(LOG_CONFIG_PROPERTY);
            File file = logConfigFile = logConfigPath == null ? FileUtils.getAbsolutePath().resolve(DEFAULT_LOG_CONFIG).toFile() : new File(logConfigPath);
            if (logConfigFile.exists()) {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.setConfigLocation(logConfigFile.toURI());
                String fileName = System.getProperty(FILE_NAME_PROPERTY);
                String fileDirName = System.getProperty(DIR_PROPERTY);
                try {
                    if (fileDirName != null) {
                        RecordBlockNumberTool.readAllFiles(fileDirName);
                        break block7;
                    }
                    RecordBlockNumberTool.readRecordFile(fileName);
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Got IOException", (Throwable)e);
                }
            } else {
                throw new RuntimeException("Could not find log4j2 configuration file " + String.valueOf(logConfigFile));
            }
        }
    }

    public static void readAllFiles(String sourceDir) throws IOException {
        File folder = new File(sourceDir);
        Object[] streamFiles = folder.listFiles(f -> f.getAbsolutePath().endsWith(COMPRESSED_RECORD_STREAM_EXTENSION) || f.getAbsolutePath().endsWith(RECORD_STREAM_EXTENSION));
        Arrays.sort(streamFiles);
        ArrayList<File> totalList = new ArrayList<File>();
        totalList.addAll(Arrays.asList((File[])Optional.ofNullable(streamFiles).orElse(new File[0])));
        byte[] startRunningHash = null;
        byte[] endRunningHash = null;
        for (File item : totalList) {
            Pair<byte[], byte[]> hashes = RecordBlockNumberTool.readRecordFile(item.getAbsolutePath());
            if (hashes.getLeft() == null || hashes.getRight() == null) {
                LOGGER.error(MARKER, "startRunningHash or endRunningHash of file {} is null", (Object)item.getAbsolutePath());
                return;
            }
            startRunningHash = (byte[])hashes.getLeft();
            if (endRunningHash != null && !Arrays.equals(startRunningHash, endRunningHash)) {
                LOGGER.error(MARKER, "startRunningHash of file {} is not equal to endRunningHash of previous file", (Object)item.getAbsolutePath());
            }
            endRunningHash = (byte[])hashes.getRight();
        }
    }
}

