/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.service.registry.Interception;
import io.helidon.service.registry.InterceptionContext;
import io.helidon.service.registry.InterceptionException;
import io.helidon.service.registry.InterceptionInvoker;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

class Invocation<V>
implements Interception.Interceptor.Chain<V> {
    private final InterceptionContext ctx;
    private final List<Supplier<Interception.Interceptor>> interceptors;
    private final Set<Class<? extends Throwable>> checkedExceptions;
    private int interceptorPos;
    private InterceptionInvoker<V> call;

    private Invocation(InterceptionContext ctx, List<Supplier<Interception.Interceptor>> interceptors, InterceptionInvoker<V> call, Set<Class<? extends Throwable>> checkedExceptions) {
        this.ctx = ctx;
        this.call = call;
        this.interceptors = List.copyOf(interceptors);
        this.checkedExceptions = checkedExceptions;
    }

    static <V> V invokeInterception(InterceptionContext ctx, List<? extends Supplier<Interception.Interceptor>> interceptors, InterceptionInvoker<V> call, Object[] args, Set<Class<? extends Throwable>> checkedExceptions) throws Exception {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(call);
        Objects.requireNonNull(args);
        Objects.requireNonNull(checkedExceptions);
        if (interceptors.isEmpty()) {
            try {
                return call.invoke(args);
            }
            catch (Throwable t) {
                if (Invocation.shouldThrow(checkedExceptions, t.getClass())) {
                    throw t;
                }
                throw new InterceptionException("Error in interceptor chain processing", t, true);
            }
        }
        return new Invocation<V>(ctx, interceptors, call, checkedExceptions).proceed(args);
    }

    public String toString() {
        return String.valueOf(this.ctx.elementInfo());
    }

    @Override
    public V proceed(Object ... args) throws Exception {
        if (this.call == null) {
            throw new InterceptionException("Duplicate invocation, or unknown call type: " + String.valueOf(this), true);
        }
        if (this.interceptorPos < this.interceptors.size()) {
            Supplier<Interception.Interceptor> interceptorProvider = this.interceptors.get(this.interceptorPos);
            Interception.Interceptor interceptor = interceptorProvider.get();
            ++this.interceptorPos;
            try {
                return interceptor.proceed(this.ctx, this, args);
            }
            catch (RuntimeException e) {
                --this.interceptorPos;
                throw e;
            }
            catch (Throwable t) {
                --this.interceptorPos;
                if (Invocation.shouldThrow(this.checkedExceptions, t.getClass())) {
                    throw t;
                }
                String message = "Error in interceptor chain processing";
                boolean called = this.call == null;
                throw new InterceptionException(message, t, called);
            }
        }
        InterceptionInvoker<V> call = this.call;
        this.call = null;
        try {
            return call.invoke(args);
        }
        catch (InterceptionException e) {
            if (e.targetWasCalled()) {
                this.call = call;
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.call = call;
            throw e;
        }
        catch (Throwable t) {
            this.call = call;
            if (Invocation.shouldThrow(this.checkedExceptions, t.getClass())) {
                throw t;
            }
            throw new InterceptionException("Error in interceptor chain processing", t, true);
        }
    }

    private static boolean shouldThrow(Set<Class<? extends Throwable>> checked, Class<? extends Throwable> t) {
        if (checked.contains(t)) {
            return true;
        }
        for (Class<? extends Throwable> aClass : checked) {
            if (!aClass.isAssignableFrom(t)) continue;
            return true;
        }
        return false;
    }
}

