/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.merkledb.MerkleDbStatistics;
import com.swirlds.merkledb.collections.LongList;
import com.swirlds.merkledb.collections.OffHeapUser;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.files.DataFileReader;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LongSummaryStatistics;
import java.util.function.IntConsumer;
import org.hiero.consensus.metrics.FunctionGauge;

public class MerkleDbStatisticsUpdater {
    private static final FunctionGauge.Config<Long> COUNT_OF_OPEN_DATABASES_CONFIG = new FunctionGauge.Config("merkle_db", "merkledb_count", Long.class, MerkleDbDataSource::getCountOfOpenDatabases).withDescription("the number of MerkleDb instances that have been created but not released").withFormat("%d");
    private final MerkleDbStatistics statistics;

    public MerkleDbStatisticsUpdater(@NonNull MerkleDbConfig config, @NonNull String tableName) {
        this.statistics = new MerkleDbStatistics(config, tableName);
    }

    public void registerMetrics(Metrics metrics) {
        metrics.getOrCreate(COUNT_OF_OPEN_DATABASES_CONFIG);
        this.statistics.registerMetrics(metrics);
    }

    void setFlushLeafKeysStoreFileSize(DataFileReader newLeafKeysFile) {
        this.statistics.setFlushLeafKeysStoreFileSizeMb(newLeafKeysFile == null ? 0.0 : (double)newLeafKeysFile.getSize() * 9.5367431640625E-7);
    }

    void setFlushLeavesStoreFileSize(DataFileReader newLeafKeysFile) {
        this.statistics.setFlushLeavesStoreFileSizeMb(newLeafKeysFile == null ? 0.0 : (double)newLeafKeysFile.getSize() * 9.5367431640625E-7);
    }

    void setFlushHashesStoreFileSize(DataFileReader newHashesFile) {
        this.statistics.setFlushHashesStoreFileSizeMb(newHashesFile == null ? 0.0 : (double)newHashesFile.getSize() * 9.5367431640625E-7);
    }

    int updateHashesStoreFileStats(MerkleDbDataSource dataSource) {
        if (dataSource.getHashStoreDisk() != null) {
            LongSummaryStatistics internalHashesFileSizeStats = dataSource.getHashStoreDisk().getFilesSizeStatistics();
            this.statistics.setHashesStoreFileCount((int)internalHashesFileSizeStats.getCount());
            int fileSizeInMb = (int)((double)internalHashesFileSizeStats.getSum() * 9.5367431640625E-7);
            this.statistics.setHashesStoreFileSizeMb(fileSizeInMb);
            return fileSizeInMb;
        }
        return 0;
    }

    private int updateLeavesStoreFileStats(MerkleDbDataSource dataSource) {
        LongSummaryStatistics leafDataFileSizeStats = dataSource.getPathToKeyValue().getFilesSizeStatistics();
        this.statistics.setLeavesStoreFileCount((int)leafDataFileSizeStats.getCount());
        int fileSizeInMb = (int)((double)leafDataFileSizeStats.getSum() * 9.5367431640625E-7);
        this.statistics.setLeavesStoreFileSizeMb(fileSizeInMb);
        return fileSizeInMb;
    }

    private int updateLeafKeysStoreFileStats(MerkleDbDataSource dataSource) {
        if (dataSource.getKeyToPath() != null) {
            LongSummaryStatistics leafKeyFileSizeStats = dataSource.getKeyToPath().getFilesSizeStatistics();
            this.statistics.setLeafKeysStoreFileCount((int)leafKeyFileSizeStats.getCount());
            int fileSizeInMb = (int)((double)leafKeyFileSizeStats.getSum() * 9.5367431640625E-7);
            this.statistics.setLeafKeysStoreFileSizeMb(fileSizeInMb);
            return fileSizeInMb;
        }
        return 0;
    }

    void updateStoreFileStats(MerkleDbDataSource dataSource) {
        this.statistics.setTotalFileSizeMb(this.updateHashesStoreFileStats(dataSource) + this.updateLeavesStoreFileStats(dataSource) + this.updateLeafKeysStoreFileStats(dataSource));
    }

    void updateOffHeapStats(MerkleDbDataSource dataSource) {
        int totalOffHeapMemoryConsumption = MerkleDbStatisticsUpdater.updateOffHeapStat(dataSource.getPathToDiskLocationInternalNodes(), this.statistics::setOffHeapHashesIndexMb) + MerkleDbStatisticsUpdater.updateOffHeapStat(dataSource.getPathToDiskLocationLeafNodes(), this.statistics::setOffHeapLeavesIndexMb);
        if (dataSource.getKeyToPath() != null) {
            totalOffHeapMemoryConsumption += MerkleDbStatisticsUpdater.updateOffHeapStat(dataSource.getKeyToPath(), this.statistics::setOffHeapObjectKeyBucketsIndexMb);
        }
        if (dataSource.getHashStoreRam() != null) {
            totalOffHeapMemoryConsumption += MerkleDbStatisticsUpdater.updateOffHeapStat((OffHeapUser)((Object)dataSource.getHashStoreRam()), this.statistics::setOffHeapHashesListMb);
        }
        this.statistics.setOffHeapDataSourceMb(totalOffHeapMemoryConsumption);
    }

    void countLeafReads() {
        this.statistics.countLeafReads();
    }

    void countLeafKeyReads() {
        this.statistics.countLeafKeyReads();
    }

    void countHashReads() {
        this.statistics.countHashReads();
    }

    void countFlushLeavesWritten() {
        this.statistics.countFlushLeavesWritten(1L);
    }

    void countFlushLeafKeysWritten() {
        this.statistics.countFlushLeafKeysWritten(1L);
    }

    void countFlushLeavesDeleted() {
        this.statistics.countFlushLeavesDeleted(1L);
    }

    void countFlushHashesWritten() {
        this.statistics.countFlushHashesWritten(1L);
    }

    private static int updateOffHeapStat(LongList longList, IntConsumer updateFunction) {
        if (longList instanceof OffHeapUser) {
            OffHeapUser longListOffHeap = (OffHeapUser)((Object)longList);
            int result = (int)((double)longListOffHeap.getOffHeapConsumption() * 9.5367431640625E-7);
            updateFunction.accept(result);
            return result;
        }
        return 0;
    }

    private static int updateOffHeapStat(OffHeapUser offHeapUser, IntConsumer updateFunction) {
        int usage = (int)((double)offHeapUser.getOffHeapConsumption() * 9.5367431640625E-7);
        updateFunction.accept(usage);
        return usage;
    }

    void setLeafKeysStoreCompactionTimeMs(Integer compactionLevel, Long time) {
        this.statistics.setLeafKeysStoreCompactionTimeMs(compactionLevel, time);
    }

    void setLeafKeysStoreCompactionSavedSpaceMb(Integer compactionLevel, Double savedSpace) {
        this.statistics.setLeafKeysStoreCompactionSavedSpaceMb(compactionLevel, savedSpace);
    }

    void setLeafKeysStoreFileSizeByLevelMb(Integer compactionLevel, Double savedSpace) {
        this.statistics.setLeafKeysStoreFileSizeByLevelMb(compactionLevel, savedSpace);
    }

    void setHashesStoreCompactionTimeMs(Integer compactionLevel, Long time) {
        this.statistics.setHashesStoreCompactionTimeMs(compactionLevel, time);
    }

    void setHashesStoreCompactionSavedSpaceMb(Integer compactionLevel, Double savedSpace) {
        this.statistics.setHashesStoreCompactionSavedSpaceMb(compactionLevel, savedSpace);
    }

    void setHashesStoreFileSizeByLevelMb(Integer compactionLevel, Double savedSpace) {
        this.statistics.setHashesStoreFileSizeByLevelMb(compactionLevel, savedSpace);
    }

    void setLeavesStoreCompactionTimeMs(Integer compactionType, Long time) {
        this.statistics.setLeavesStoreCompactionTimeMs(compactionType, time);
    }

    void setLeavesStoreCompactionSavedSpaceMb(Integer compactionType, Double savedSpace) {
        this.statistics.setLeavesStoreCompactionSavedSpaceMb(compactionType, savedSpace);
    }

    void setLeavesStoreFileSizeByLevelMb(Integer compactionType, Double savedSpace) {
        this.statistics.setLeavesStoreFileSizeByLevelMb(compactionType, savedSpace);
    }
}

