/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl.schemas;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.addressbook.impl.schemas.V053AddressBookSchema;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.WritableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;

public class V068AddressBookSchema
extends Schema<SemanticVersion> {
    public static final String ACCOUNT_NODE_REL_STATE_KEY = "ACCOUNT_NODE_REL";
    public static final int ACCOUNT_NODE_REL_STATE_ID = StateKey.KeyOneOfType.ADDRESSBOOKSERVICE_I_ACCOUNT_NODE_REL.protoOrdinal();
    public static final String ACCOUNT_NODE_REL_STATE_LABEL = StateMetadata.computeLabel((String)"AddressBookService", (String)"ACCOUNT_NODE_REL");
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(68).patch(0).build();
    private static final long MAX_RELATIONS = 100L;

    public V068AddressBookSchema() {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.keyValue((int)ACCOUNT_NODE_REL_STATE_ID, (String)ACCOUNT_NODE_REL_STATE_KEY, (Codec)AccountID.PROTOBUF, (Codec)NodeId.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        if (!ctx.isGenesis()) {
            ReadableKVState nodeState = ctx.previousStates().get(V053AddressBookSchema.NODES_STATE_ID);
            WritableKVState relState = ctx.newStates().get(ACCOUNT_NODE_REL_STATE_ID);
            for (int i = 0; i < 100; ++i) {
                EntityNumber nodeId = EntityNumber.newBuilder().number((long)i).build();
                Node node = (Node)nodeState.get((Object)nodeId);
                if (node == null || !node.hasAccountId()) continue;
                relState.put((Object)node.accountId(), (Object)NodeId.newBuilder().id(node.nodeId()).build());
            }
        }
    }
}

