/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm;

import java.math.BigInteger;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.MainnetEVMs;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.operation.OperationRegistry;
import org.hyperledger.besu.evm.operation.Push0Operation;

public class ClassicEVMs {
    private ClassicEVMs() {
    }

    public static EVM spiral(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(ClassicEVMs.spiralOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.SHANGHAI);
    }

    public static OperationRegistry spiralOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry registry = new OperationRegistry();
        MainnetEVMs.registerIstanbulOperations(registry, gasCalculator, chainId);
        registry.put(new Push0Operation(gasCalculator));
        return registry;
    }
}

