/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.file.SystemDeleteTransactionBody;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.FileFeeBuilder;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.impl.WritableFileStore;
import com.hedera.node.app.service.file.impl.utils.FileServiceUtils;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileSystemDeleteHandler
implements TransactionHandler {
    private final FileFeeBuilder usageEstimator;

    @Inject
    public FileSystemDeleteHandler(FileFeeBuilder usageEstimator) {
        this.usageEstimator = usageEstimator;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        SystemDeleteTransactionBody transactionBody = txn.systemDeleteOrThrow();
        if (transactionBody.fileID() == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_FILE_ID);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        SystemDeleteTransactionBody transactionBody = context.body().systemDeleteOrThrow();
        ReadableFileStore fileStore = (ReadableFileStore)context.createStore(ReadableFileStore.class);
        FileID transactionFileId = Objects.requireNonNull(transactionBody.fileID());
        FileServiceUtils.preValidate(transactionFileId, fileStore, context);
    }

    public void handle(@NonNull HandleContext handleContext) throws HandleException {
        WritableFileStore fileStore;
        Objects.requireNonNull(handleContext);
        SystemDeleteTransactionBody systemDeleteTransactionBody = handleContext.body().systemDeleteOrThrow();
        if (!systemDeleteTransactionBody.hasFileID()) {
            throw new HandleException(ResponseCodeEnum.INVALID_FILE_ID);
        }
        FileID fileId = systemDeleteTransactionBody.fileIDOrThrow();
        LedgerConfig ledgerConfig = (LedgerConfig)handleContext.configuration().getConfigData(LedgerConfig.class);
        File file = FileServiceUtils.verifyNotSystemFile(ledgerConfig, fileStore = (WritableFileStore)handleContext.storeFactory().writableStore(WritableFileStore.class), fileId);
        long oldExpiration = file.expirationSecond();
        long newExpiry = systemDeleteTransactionBody.expirationTimeOrElse(new TimestampSeconds(oldExpiration)).seconds();
        if (newExpiry <= handleContext.consensusNow().getEpochSecond()) {
            fileStore.removeFile(fileId);
        } else {
            File.Builder fileBuilder = new File.Builder().fileId(file.fileId()).preSystemDeleteExpirationSecond(oldExpiration).expirationSecond(newExpiry).keys(file.keys()).contents(file.contents()).memo(file.memo()).deleted(true);
            fileStore.put(fileBuilder.build());
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody txnBody = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageEstimator.getSystemDeleteFileTxFeeMatrices(CommonPbjConverters.fromPbj((TransactionBody)txnBody), sigValueObj));
    }
}

