/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.hints.handlers.HintsHandlers;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.app.history.handlers.HistoryHandlers;
import com.hedera.node.app.info.DiskStartupNetworks;
import com.hedera.node.app.service.addressbook.impl.handlers.AddressBookHandlers;
import com.hedera.node.app.service.consensus.impl.handlers.ConsensusHandlers;
import com.hedera.node.app.service.contract.impl.ContractServiceImpl;
import com.hedera.node.app.service.contract.impl.handlers.ContractHandlers;
import com.hedera.node.app.service.contract.impl.handlers.EthereumTransactionHandler;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.file.impl.handlers.FileHandlers;
import com.hedera.node.app.service.networkadmin.impl.handlers.NetworkAdminHandlers;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceImpl;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleHandlers;
import com.hedera.node.app.service.token.impl.handlers.TokenHandlers;
import com.hedera.node.app.service.util.impl.UtilServiceImpl;
import com.hedera.node.app.service.util.impl.handlers.UtilHandlers;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.state.WorkingStateAccessor;
import com.hedera.node.app.workflows.dispatcher.TransactionHandlers;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.CacheConfig;
import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.state.State;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.inject.Singleton;

@Module
public interface HandleWorkflowModule {
    public static final Runnable NO_OP = () -> {};

    @Provides
    @Singleton
    public static EntityIdFactory provideEntityIdFactory(@NonNull AppContext appContext) {
        return appContext.idFactory();
    }

    @Provides
    @Singleton
    public static Supplier<ContractHandlers> provideContractHandlers(@NonNull ContractServiceImpl contractService) {
        return () -> ((ContractServiceImpl)contractService).handlers();
    }

    @Provides
    @Singleton
    public static ScheduleHandlers provideScheduleHandlers(@NonNull ScheduleServiceImpl scheduleService) {
        return scheduleService.handlers();
    }

    @Provides
    @Singleton
    public static UtilHandlers provideUtilHandlers(@NonNull UtilServiceImpl utilService) {
        return utilService.handlers();
    }

    @Provides
    @Singleton
    public static HintsHandlers provideHintsHandlers(@NonNull HintsService hintsService) {
        return hintsService.handlers();
    }

    @Provides
    @Singleton
    public static HistoryHandlers provideHistoryHandlers(@NonNull HistoryService historyService) {
        return historyService.handlers();
    }

    @Provides
    @Singleton
    public static EthereumTransactionHandler provideEthereumTransactionHandler(@NonNull ContractServiceImpl contractService) {
        return contractService.handlers().ethereumTransactionHandler();
    }

    @Provides
    @Singleton
    public static BiConsumer<Roster, Path> provideRosterExportHelper() {
        return (roster, path) -> {
            Network network = Network.newBuilder().nodeMetadata(roster.rosterEntries().stream().map(entry -> new NodeMetadata(entry, null)).toList()).build();
            DiskStartupNetworks.tryToExport(network, path);
        };
    }

    @Provides
    public static Supplier<AutoCloseableWrapper<State>> provideStateSupplier(@NonNull WorkingStateAccessor workingStateAccessor) {
        return () -> new AutoCloseableWrapper((Object)workingStateAccessor.getState(), NO_OP);
    }

    @Provides
    @Named(value="CacheWarmer")
    public static Executor provideCacheWarmerExecutor(@NonNull ConfigProvider configProvider) {
        VersionedConfiguration config = configProvider.getConfiguration();
        int parallelism = ((CacheConfig)config.getConfigData(CacheConfig.class)).warmThreads();
        return new ForkJoinPool(parallelism);
    }

    @Provides
    @Named(value="FreezeService")
    public static Executor provideFreezeServiceExecutor() {
        return new ForkJoinPool(1, ForkJoinPool.defaultForkJoinWorkerThreadFactory, Thread.getDefaultUncaughtExceptionHandler(), true);
    }

    @Provides
    @Singleton
    public static TransactionHandlers provideTransactionHandlers(@NonNull NetworkAdminHandlers networkAdminHandlers, @NonNull ConsensusHandlers consensusHandlers, @NonNull FileHandlers fileHandlers, @NonNull Supplier<ContractHandlers> contractHandlers, @NonNull ScheduleHandlers scheduleHandlers, @NonNull TokenHandlers tokenHandlers, @NonNull UtilHandlers utilHandlers, @NonNull AddressBookHandlers addressBookHandlers, @NonNull HintsHandlers hintsHandlers, @NonNull HistoryHandlers historyHandlers) {
        return new TransactionHandlers(consensusHandlers.consensusCreateTopicHandler(), consensusHandlers.consensusUpdateTopicHandler(), consensusHandlers.consensusDeleteTopicHandler(), consensusHandlers.consensusSubmitMessageHandler(), contractHandlers.get().contractCreateHandler(), contractHandlers.get().contractUpdateHandler(), contractHandlers.get().contractCallHandler(), contractHandlers.get().contractDeleteHandler(), contractHandlers.get().contractSystemDeleteHandler(), contractHandlers.get().contractSystemUndeleteHandler(), contractHandlers.get().ethereumTransactionHandler(), contractHandlers.get().hookStoreHandler(), contractHandlers.get().hookDispatchHandler(), tokenHandlers.cryptoCreateHandler(), tokenHandlers.cryptoUpdateHandler(), tokenHandlers.cryptoTransferHandler(), tokenHandlers.cryptoDeleteHandler(), tokenHandlers.cryptoApproveAllowanceHandler(), tokenHandlers.cryptoDeleteAllowanceHandler(), tokenHandlers.cryptoAddLiveHashHandler(), tokenHandlers.cryptoDeleteLiveHashHandler(), fileHandlers.fileCreateHandler(), fileHandlers.fileUpdateHandler(), fileHandlers.fileDeleteHandler(), fileHandlers.fileAppendHandler(), fileHandlers.fileSystemDeleteHandler(), fileHandlers.fileSystemUndeleteHandler(), networkAdminHandlers.freezeHandler(), networkAdminHandlers.networkUncheckedSubmitHandler(), scheduleHandlers.scheduleCreateHandler(), scheduleHandlers.scheduleSignHandler(), scheduleHandlers.scheduleDeleteHandler(), tokenHandlers.tokenCreateHandler(), tokenHandlers.tokenUpdateHandler(), tokenHandlers.tokenMintHandler(), tokenHandlers.tokenBurnHandler(), tokenHandlers.tokenDeleteHandler(), tokenHandlers.tokenAccountWipeHandler(), tokenHandlers.tokenFreezeAccountHandler(), tokenHandlers.tokenUnfreezeAccountHandler(), tokenHandlers.tokenGrantKycToAccountHandler(), tokenHandlers.tokenRevokeKycFromAccountHandler(), tokenHandlers.tokenAssociateToAccountHandler(), tokenHandlers.tokenDissociateFromAccountHandler(), tokenHandlers.tokenFeeScheduleUpdateHandler(), tokenHandlers.tokenPauseHandler(), tokenHandlers.tokenUnpauseHandler(), tokenHandlers.tokenUpdateNftsHandler(), tokenHandlers.tokenRejectHandler(), tokenHandlers.tokenAirdropsHandler(), tokenHandlers.tokenCancelAirdropHandler(), addressBookHandlers.nodeCreateHandler(), addressBookHandlers.nodeUpdateHandler(), addressBookHandlers.nodeDeleteHandler(), tokenHandlers.tokenClaimAirdropHandler(), hintsHandlers.keyPublicationHandler(), hintsHandlers.preprocessingVoteHandler(), hintsHandlers.partialSignatureHandler(), utilHandlers.prngHandler(), utilHandlers.atomicBatchHandler(), historyHandlers.historyProofKeyPublicationHandler(), historyHandlers.historyProofSignatureHandler(), historyHandlers.historyProofVoteHandler(), hintsHandlers.crsPublicationHandler());
    }
}

