/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.connectivity;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Objects;
import org.hiero.consensus.gossip.config.GossipConfig;
import org.hiero.consensus.gossip.config.NetworkEndpoint;
import org.hiero.consensus.gossip.config.SocketConfig;
import org.hiero.consensus.gossip.impl.network.PeerInfo;
import org.hiero.consensus.model.node.NodeId;

public interface SocketFactory {
    public static final byte[] ALL_INTERFACES = new byte[]{0, 0, 0, 0};
    public static final int IP_TOP_MIN = 0;
    public static final int IP_TOP_MAX = 255;

    public static boolean isIpTopInRange(int ipTos) {
        return 0 <= ipTos && ipTos <= 255;
    }

    public static void configureAndBind(@NonNull NodeId selfId, @NonNull ServerSocket serverSocket, @NonNull SocketConfig socketConfig, @NonNull GossipConfig gossipConfig, int port) throws IOException {
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(serverSocket);
        Objects.requireNonNull(socketConfig);
        Objects.requireNonNull(gossipConfig);
        NetworkEndpoint networkEndpoint = gossipConfig.getInterfaceBindings(selfId.id()).orElseGet(() -> {
            try {
                return new NetworkEndpoint(Long.valueOf(selfId.id()), InetAddress.getByAddress(ALL_INTERFACES), port);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Host 'ALL_INTERFACES' not found", e);
            }
        });
        if (SocketFactory.isIpTopInRange(socketConfig.ipTos())) {
            serverSocket.setOption(StandardSocketOptions.IP_TOS, socketConfig.ipTos());
        }
        InetSocketAddress endpoint = new InetSocketAddress(networkEndpoint.hostname(), networkEndpoint.port());
        serverSocket.setReuseAddress(true);
        serverSocket.bind(endpoint);
        serverSocket.setSoTimeout(socketConfig.timeoutServerAcceptConnect());
    }

    public static void configureAndConnect(@NonNull Socket clientSocket, @NonNull SocketConfig socketConfig, @NonNull String hostname, int port) throws IOException {
        if (SocketFactory.isIpTopInRange(socketConfig.ipTos())) {
            clientSocket.setOption(StandardSocketOptions.IP_TOS, socketConfig.ipTos());
        }
        clientSocket.setSoTimeout(socketConfig.timeoutSyncClientSocket());
        clientSocket.setTcpNoDelay(socketConfig.tcpNoDelay());
        clientSocket.connect(new InetSocketAddress(hostname, port), socketConfig.timeoutSyncClientConnect());
    }

    @NonNull
    public ServerSocket createServerSocket(int var1) throws IOException;

    @NonNull
    public Socket createClientSocket(@NonNull String var1, int var2) throws IOException;

    public void reload(@NonNull Collection<PeerInfo> var1);
}

