/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.query;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.FeeContextImpl;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.fees.SimpleFeeContextImpl;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.CryptoTransferHandler;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import com.hedera.node.app.spi.fees.util.FeeUtils;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.spi.workflows.InsufficientBalanceException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.validation.ExpiryValidation;
import com.hedera.node.app.workflows.SolvencyPreCheck;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.handle.dispatch.DispatchValidator;
import com.hedera.node.app.workflows.ingest.IngestChecker;
import com.hedera.node.app.workflows.purechecks.PureChecksContextImpl;
import com.hedera.node.config.data.FeesConfig;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.hapi.fees.FeeResult;

@Singleton
public class QueryChecker {
    private final Authorizer authorizer;
    private final CryptoTransferHandler cryptoTransferHandler;
    private final SolvencyPreCheck solvencyPreCheck;
    private final ExpiryValidation expiryValidation;
    private final FeeManager feeManager;
    private final TransactionDispatcher dispatcher;
    private final IngestChecker ingestChecker;

    @Inject
    public QueryChecker(@NonNull Authorizer authorizer, @NonNull CryptoTransferHandler cryptoTransferHandler, @NonNull SolvencyPreCheck solvencyPreCheck, @NonNull ExpiryValidation expiryValidation, @NonNull FeeManager feeManager, @NonNull TransactionDispatcher dispatcher, @NonNull IngestChecker ingestChecker) {
        this.authorizer = Objects.requireNonNull(authorizer);
        this.cryptoTransferHandler = Objects.requireNonNull(cryptoTransferHandler);
        this.solvencyPreCheck = Objects.requireNonNull(solvencyPreCheck);
        this.expiryValidation = Objects.requireNonNull(expiryValidation);
        this.feeManager = Objects.requireNonNull(feeManager);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.ingestChecker = Objects.requireNonNull(ingestChecker);
    }

    public void validateCryptoTransfer(@NonNull ReadableAccountStore accountStore, @NonNull TransactionInfo transactionInfo, @NonNull Configuration configuration) throws PreCheckException {
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(transactionInfo);
        Objects.requireNonNull(configuration);
        if (transactionInfo.functionality() != HederaFunctionality.CRYPTO_TRANSFER) {
            throw new PreCheckException(ResponseCodeEnum.INSUFFICIENT_TX_FEE);
        }
        TransactionBody txBody = transactionInfo.txBody();
        PureChecksContextImpl pureChecksContext = new PureChecksContextImpl(txBody, this.dispatcher);
        this.cryptoTransferHandler.pureChecks((PureChecksContext)pureChecksContext);
        for (AccountAmount accountAmount : txBody.cryptoTransferOrThrow().transfersOrThrow().accountAmounts()) {
            AccountID accountID = accountAmount.accountIDOrElse(AccountID.DEFAULT);
            long amount = accountAmount.amount();
            if (amount >= 0L || Objects.equals(accountID, transactionInfo.payerID())) continue;
            Account account = accountStore.getAliasedAccountById(accountID);
            if (account == null) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
            }
            this.ingestChecker.verifyAccountSignature(transactionInfo, account, configuration);
        }
    }

    public void validateAccountBalances(@NonNull ReadableAccountStore accountStore, @NonNull TransactionInfo txInfo, @NonNull Account payer, long nodePayment, long transferTxnFee) throws PreCheckException {
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(txInfo);
        Objects.requireNonNull(payer);
        AccountID payerID = txInfo.payerID();
        AccountID nodeAccountID = txInfo.txBody().nodeAccountIDOrThrow();
        List transfers = txInfo.txBody().cryptoTransferOrThrow().transfersOrThrow().accountAmounts();
        this.solvencyPreCheck.checkSolvency(txInfo, payer, new Fees(transferTxnFee, 0L, 0L), DispatchValidator.WorkflowCheck.NOT_INGEST);
        if (transfers.isEmpty()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_AMOUNTS);
        }
        boolean nodeReceivesSome = false;
        for (AccountAmount transfer : transfers) {
            AccountID accountID = transfer.accountIDOrThrow();
            long amount = transfer.amount();
            if (amount == Long.MIN_VALUE) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_AMOUNTS);
            }
            if (!Objects.equals(accountID, payerID)) {
                Account account = accountStore.getAccountById(accountID);
                if (account == null) {
                    throw new PreCheckException(ResponseCodeEnum.ACCOUNT_ID_DOES_NOT_EXIST);
                }
                if (amount < 0L && account.tinybarBalance() < -amount) {
                    this.expiryValidation.checkAccountExpiry(account);
                    throw new InsufficientBalanceException(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE, -amount);
                }
                if (amount < 0L || !nodeAccountID.equals((Object)accountID)) continue;
                nodeReceivesSome = true;
                if (amount >= nodePayment) continue;
                throw new InsufficientBalanceException(ResponseCodeEnum.INSUFFICIENT_TX_FEE, nodePayment);
            }
            if (amount >= 0L || payer.tinybarBalance() - transferTxnFee >= -amount) continue;
            throw new InsufficientBalanceException(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE, -amount + transferTxnFee);
        }
        if (!nodeReceivesSome) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT);
        }
    }

    public void checkPermissions(@NonNull AccountID payer, @NonNull HederaFunctionality functionality) throws PreCheckException {
        Objects.requireNonNull(payer);
        Objects.requireNonNull(functionality);
        if (!this.authorizer.isAuthorized(payer, functionality)) {
            throw new PreCheckException(ResponseCodeEnum.NOT_SUPPORTED);
        }
    }

    public long estimateTxFees(@NonNull ReadableStoreFactory storeFactory, @NonNull Instant consensusTime, @NonNull TransactionInfo transactionInfo, @NonNull Key payerKey, @NonNull Configuration configuration) {
        FeeContextImpl feeContext = new FeeContextImpl(consensusTime, transactionInfo, payerKey, transactionInfo.payerID(), this.feeManager, storeFactory, configuration, this.authorizer, -1, this.dispatcher);
        if (((FeesConfig)configuration.getConfigData(FeesConfig.class)).simpleFeesEnabled()) {
            FeeResult transferFeeResult = Objects.requireNonNull(this.feeManager.getSimpleFeeCalculator()).calculateTxFee(transactionInfo.txBody(), (SimpleFeeContext)new SimpleFeeContextImpl(feeContext, null));
            Fees fees = FeeUtils.feeResultToFees((FeeResult)transferFeeResult, (ExchangeRate)CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.ExchangeRate)feeContext.activeRate()));
            return fees.totalFee();
        }
        return this.cryptoTransferHandler.calculateFees((FeeContext)feeContext).totalFee();
    }
}

