/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.rejecttokens;

import com.esaulpaugh.headlong.abi.Function;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.rejecttokens.RejectTokensDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RejectTokensTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod TOKEN_REJECT = SystemContractMethod.declare("rejectTokens(address,address[],(address,int64)[])", "(int64)").withCategories(SystemContractMethod.Category.REJECT);
    public static final SystemContractMethod HRC_TOKEN_REJECT_FT = SystemContractMethod.declare("rejectTokenFT()", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.REJECT);
    public static final SystemContractMethod HRC_TOKEN_REJECT_NFT = SystemContractMethod.declare("rejectTokenNFTs(int64[])", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withVariant(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.REJECT);
    private final RejectTokensDecoder decoder;
    private final Map<Function, DispatchGasCalculator> gasCalculators = new ConcurrentHashMap<Function, DispatchGasCalculator>();

    @Inject
    public RejectTokensTranslator(@NonNull RejectTokensDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(TOKEN_REJECT, HRC_TOKEN_REJECT_FT, HRC_TOKEN_REJECT_NFT);
        this.gasCalculators.put(TOKEN_REJECT.function(), RejectTokensTranslator::gasRequirement);
        this.gasCalculators.put(HRC_TOKEN_REJECT_FT.function(), RejectTokensTranslator::gasRequirementHRCFungible);
        this.gasCalculators.put(HRC_TOKEN_REJECT_NFT.function(), RejectTokensTranslator::gasRequirementHRCNft);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        boolean rejectEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractRejectTokensEnabled();
        if (!rejectEnabled) {
            return Optional.empty();
        }
        return attempt.isRedirect() ? attempt.isMethod(HRC_TOKEN_REJECT_FT, HRC_TOKEN_REJECT_NFT) : attempt.isMethod(TOKEN_REJECT);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        Optional<DispatchGasCalculator> gasRequirement = this.gasCalculators.entrySet().stream().filter(entry -> attempt.isSelector((Function)entry.getKey())).map(Map.Entry::getValue).findFirst();
        return new DispatchForResponseCodeHtsCall(attempt, this.bodyFor(attempt), gasRequirement.get());
    }

    public static long gasRequirementHRCFungible(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.TOKEN_REJECT_FT, payerId);
    }

    public static long gasRequirementHRCNft(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.TOKEN_REJECT_NFT, payerId);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        Long accumulatedCanonicalPricing = body.tokenReject().rejections().stream().map(rejection -> {
            if (rejection.hasFungibleToken()) {
                return systemContractGasCalculator.canonicalPriceInTinycents(DispatchType.TOKEN_REJECT_FT);
            }
            return systemContractGasCalculator.canonicalPriceInTinycents(DispatchType.TOKEN_REJECT_NFT);
        }).reduce(0L, Long::sum);
        return systemContractGasCalculator.gasRequirementWithTinycents(body, payerId, accumulatedCanonicalPricing);
    }

    private TransactionBody bodyFor(@NonNull HtsCallAttempt attempt) {
        return attempt.isSelector(TOKEN_REJECT) ? this.bodyForClassic(attempt) : this.bodyForHRC(attempt);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        return this.decoder.decodeTokenRejects(attempt);
    }

    private TransactionBody bodyForHRC(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(HRC_TOKEN_REJECT_FT)) {
            return this.decoder.decodeHrcTokenRejectFT(attempt);
        }
        return this.decoder.decodeHrcTokenRejectNFT(attempt);
    }
}

