/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.input.NoInput;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.gossip.GossipModule;
import org.hiero.consensus.gossip.ReservedSignedStateResult;
import org.hiero.consensus.gossip.impl.gossip.GossipWiring;
import org.hiero.consensus.gossip.impl.gossip.SyncGossipModular;
import org.hiero.consensus.gossip.impl.network.protocol.Protocol;
import org.hiero.consensus.gossip.impl.reconnect.ProtocolFactory;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.gossip.SyncProgress;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.monitoring.FallenBehindMonitor;
import org.hiero.consensus.state.signed.ReservedSignedState;

public final class DefaultGossipModule
implements GossipModule {
    @Nullable
    private GossipWiring gossipWiring;

    public void initialize(@NonNull WiringModel model, @NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull KeysAndCerts keysAndCerts, @NonNull Roster currentRoster, @NonNull NodeId selfId, @NonNull SemanticVersion appVersion, @NonNull IntakeEventCounter intakeEventCounter, @NonNull Supplier<ReservedSignedState> latestCompleteState, @NonNull BlockingResourceProvider<ReservedSignedStateResult> reservedSignedStateResultPromise, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager) {
        if (this.gossipWiring != null) {
            throw new IllegalStateException("Gossip module has already been initialized");
        }
        this.gossipWiring = new GossipWiring(configuration, model);
        ThreadManager threadManager = AdHocThreadManager.getStaticThreadManager();
        ProtocolFactory factory = ServiceLoader.load(ProtocolFactory.class).findFirst().orElseThrow();
        Protocol reconnectProtocol = factory.createProtocol(configuration, metrics, time, threadManager, latestCompleteState, reservedSignedStateResultPromise, fallenBehindMonitor, stateLifecycleManager);
        SyncGossipModular gossip = new SyncGossipModular(configuration, metrics, time, threadManager, keysAndCerts, currentRoster, selfId, appVersion, intakeEventCounter, fallenBehindMonitor, reconnectProtocol);
        this.gossipWiring.bind(gossip);
    }

    @NonNull
    public OutputWire<PlatformEvent> receivedEventOutputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getEventOutput();
    }

    @NonNull
    public OutputWire<SyncProgress> syncProgressOutputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getSyncProgressOutput();
    }

    @NonNull
    public InputWire<PlatformEvent> eventToGossipInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getEventInput();
    }

    @NonNull
    public InputWire<EventWindow> eventWindowInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getEventWindowInput();
    }

    @NonNull
    public InputWire<PlatformStatus> platformStatusInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getPlatformStatusInput();
    }

    @NonNull
    public InputWire<Duration> healthStatusInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getSystemHealthInput();
    }

    @NonNull
    public InputWire<NoInput> startInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getStartInput();
    }

    @NonNull
    public InputWire<NoInput> stopInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getStopInput();
    }

    @NonNull
    public InputWire<NoInput> clearInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").getClearInput();
    }

    @NonNull
    public InputWire<NoInput> pauseInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").pauseInput();
    }

    @NonNull
    public InputWire<NoInput> resumeInputWire() {
        return Objects.requireNonNull(this.gossipWiring, "Not initialized").resumeInput();
    }

    public void flush() {
        Objects.requireNonNull(this.gossipWiring, "Not initialized").flush();
    }
}

