/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.BufferData;
import java.nio.charset.StandardCharsets;

public final class HttpToken {
    private HttpToken() {
    }

    public static void validate(String token) throws IllegalArgumentException {
        char[] chars = token.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar > '\u00fe') {
                throw new IllegalArgumentException("Token contains non-ASCII character at position " + HttpToken.hex(i) + " \n" + HttpToken.debugToken(token));
            }
            if (Character.isISOControl(aChar)) {
                throw new IllegalArgumentException("Token contains control character at position " + HttpToken.hex(i) + "\n" + HttpToken.debugToken(token));
            }
            if (Character.isWhitespace(aChar)) {
                throw new IllegalArgumentException("Token contains whitespace character at position " + HttpToken.hex(i) + "\n" + HttpToken.debugToken(token));
            }
            switch (aChar) {
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    throw new IllegalArgumentException("Token contains illegal character at position " + HttpToken.hex(i) + "\n" + HttpToken.debugToken(token));
                }
            }
        }
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    private static String debugToken(String token) {
        return BufferData.create((byte[])token.getBytes(StandardCharsets.US_ASCII)).debugDataHex();
    }
}

