/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableCharList
extends AbstractMutableList<Character>
implements MutableList<Character>,
RandomAccess {
    private final MutableCharList delegate;

    public BoxedMutableCharList(MutableCharList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Character item) {
        return this.delegate.add(item.charValue());
    }

    public boolean addAll(int index, Collection<? extends Character> c) {
        char[] target = new char[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each.charValue();
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Character get(int index) {
        return Character.valueOf(this.delegate.get(index));
    }

    public Character set(int index, Character element) {
        return Character.valueOf(this.delegate.set(index, element.charValue()));
    }

    public void add(int index, Character element) {
        this.delegate.addAtIndex(index, element.charValue());
    }

    public Character remove(int index) {
        return Character.valueOf(this.delegate.removeAtIndex(index));
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Character ? this.delegate.indexOf(((Character)o).charValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Character ? this.delegate.lastIndexOf(((Character)o).charValue()) : -1;
    }

    @Override
    public MutableList<Character> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

