/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.statistics.atomic;

import org.hiero.base.concurrent.atomic.AtomicIntPair;

public class AtomicSumAndCount {
    final AtomicIntPair sumAndCount = new AtomicIntPair();

    private static double average(int sum, int count) {
        if (count == 0) {
            return 0.0;
        }
        return (double)sum / (double)count;
    }

    public void add(int value) {
        this.sumAndCount.accumulate(value, 1);
    }

    public int getSum() {
        return this.sumAndCount.getLeft();
    }

    public int getCount() {
        return this.sumAndCount.getRight();
    }

    public double average() {
        return this.sumAndCount.computeDouble(AtomicSumAndCount::average);
    }

    public double averageAndReset() {
        return this.sumAndCount.computeDoubleAndReset(AtomicSumAndCount::average);
    }

    public void reset() {
        this.sumAndCount.reset();
    }
}

