/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import org.hiero.hapi.support.fees.PiecewiseLinearCurve;
import org.hiero.hapi.support.fees.PiecewiseLinearPoint;
import org.hiero.hapi.support.fees.PricingCurve;
import org.hiero.hapi.support.fees.VariableRateDefinition;

public final class HighVolumePricingCalculator {
    public static final int UTILIZATION_SCALE = 10000;
    public static final long MULTIPLIER_SCALE = 1000L;

    private HighVolumePricingCalculator() {
    }

    public static long calculateMultiplier(@Nullable VariableRateDefinition variableRateDefinition, int utilizationBasisPoints) {
        if (variableRateDefinition == null) {
            return 1000L;
        }
        int maxMultiplier = Math.max(variableRateDefinition.maxMultiplier(), 1000);
        PricingCurve pricingCurve = variableRateDefinition.pricingCurve();
        int clampedUtilization = Math.max(0, Math.min(utilizationBasisPoints, 10000));
        long rawMultiplier = pricingCurve == null || !pricingCurve.hasPiecewiseLinear() || pricingCurve.piecewiseLinearOrElse(PiecewiseLinearCurve.DEFAULT).points().isEmpty() ? HighVolumePricingCalculator.linearInterpolate(0, 1000L, 10000, maxMultiplier, clampedUtilization) : HighVolumePricingCalculator.interpolatePiecewiseLinear(Objects.requireNonNull(pricingCurve.piecewiseLinear()), clampedUtilization);
        return Math.max(1000L, Math.min(rawMultiplier, (long)maxMultiplier));
    }

    private static long interpolatePiecewiseLinear(@NonNull PiecewiseLinearCurve curve, int utilizationBasisPoints) {
        List points = curve.points();
        if (points.size() == 1) {
            return HighVolumePricingCalculator.normalizeMultiplier(((PiecewiseLinearPoint)points.getFirst()).multiplier());
        }
        PiecewiseLinearPoint lowerPoint = null;
        PiecewiseLinearPoint upperPoint = null;
        for (PiecewiseLinearPoint point : points) {
            if (point.utilizationBasisPoints() <= utilizationBasisPoints) {
                lowerPoint = point;
            }
            if (point.utilizationBasisPoints() < utilizationBasisPoints || upperPoint != null) continue;
            upperPoint = point;
        }
        if (lowerPoint == null) {
            return HighVolumePricingCalculator.normalizeMultiplier(((PiecewiseLinearPoint)points.getFirst()).multiplier());
        }
        if (upperPoint == null) {
            return HighVolumePricingCalculator.normalizeMultiplier(((PiecewiseLinearPoint)points.getLast()).multiplier());
        }
        if (lowerPoint.utilizationBasisPoints() == upperPoint.utilizationBasisPoints()) {
            return HighVolumePricingCalculator.normalizeMultiplier(upperPoint.multiplier());
        }
        return HighVolumePricingCalculator.linearInterpolate(lowerPoint.utilizationBasisPoints(), HighVolumePricingCalculator.normalizeMultiplier(lowerPoint.multiplier()), upperPoint.utilizationBasisPoints(), HighVolumePricingCalculator.normalizeMultiplier(upperPoint.multiplier()), utilizationBasisPoints);
    }

    private static long linearInterpolate(int lowerUtilization, long lowerMultiplier, int upperUtilization, long upperMultiplier, int utilization) {
        if (upperUtilization == lowerUtilization) {
            return lowerMultiplier;
        }
        long utilizationDiff = upperUtilization - lowerUtilization;
        long multiplierDiff = upperMultiplier - lowerMultiplier;
        long offset = utilization - lowerUtilization;
        return lowerMultiplier + multiplierDiff * offset / utilizationDiff;
    }

    private static long normalizeMultiplier(long multiplier) {
        return Math.max(multiplier, 1000L);
    }
}

