/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.hapi.block.stream.Block;
import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.BlockProof;
import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.hapi.block.stream.schema.BlockSchema;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.BlockItemWriter;
import com.hedera.node.app.spi.records.SelfNodeAccountIdManager;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.internal.network.PendingProof;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileBlockItemWriter
implements BlockItemWriter {
    private static final Logger logger = LogManager.getLogger(FileBlockItemWriter.class);
    private static final ToLongFunction<File> PROOF_JSON_BLOCK_NUMBER_FN = f -> Long.parseLong(f.getName().substring(0, f.getName().length() - ".pnd.json".length()));
    private static final Comparator<File> PROOF_JSON_FILE_COMPARATOR = Comparator.comparingLong(PROOF_JSON_BLOCK_NUMBER_FN);
    private static final String COMPLETE_BLOCK_EXTENSION = ".blk";
    private static final String COMPRESSION_ALGORITHM_EXTENSION = ".gz";
    private final Path nodeScopedBlockDir;
    private final UnaryOperator<String> completeFileName;
    private final UnaryOperator<String> pendingFileName;
    private WritableStreamingData writableStreamingData;
    private State state;
    private long blockNumber;

    public FileBlockItemWriter(@NonNull ConfigProvider configProvider, @NonNull SelfNodeAccountIdManager selfNodeAccountIdManager, @NonNull FileSystem fileSystem) {
        Objects.requireNonNull(configProvider, "The supplied argument 'configProvider' cannot be null!");
        Objects.requireNonNull(selfNodeAccountIdManager, "The supplied argument 'nodeInfo' cannot be null!");
        Objects.requireNonNull(fileSystem, "The supplied argument 'fileSystem' cannot be null!");
        this.state = State.UNINITIALIZED;
        VersionedConfiguration config = configProvider.getConfiguration();
        BlockStreamConfig blockStreamConfig = (BlockStreamConfig)config.getConfigData(BlockStreamConfig.class);
        Path blockDir = fileSystem.getPath(blockStreamConfig.blockFileDir(), new String[0]);
        this.nodeScopedBlockDir = blockDir.resolve("block-" + HapiUtils.asAccountString((AccountID)selfNodeAccountIdManager.getSelfNodeAccountId()));
        this.completeFileName = name -> name + ".blk.gz";
        this.pendingFileName = name -> name + ".pnd.gz";
    }

    public static Path blockDirFor(@NonNull Configuration config) {
        Objects.requireNonNull(config);
        return FileUtils.getAbsolutePath((String)((BlockStreamConfig)config.getConfigData(BlockStreamConfig.class)).blockFileDir());
    }

    public static List<OnDiskPendingBlock> loadContiguousPendingBlocks(@NonNull Path blockDirPath, long followingBlockNumber, int maxReadDepth, int maxReadSize) {
        Objects.requireNonNull(blockDirPath);
        LinkedList<OnDiskPendingBlock> pendingBlocks = new LinkedList<OnDiskPendingBlock>();
        File[] pendingBlocksPaths = blockDirPath.toFile().listFiles();
        if (pendingBlocksPaths == null) {
            logger.warn("No subdirectories found in {}", (Object)blockDirPath);
            return pendingBlocks;
        }
        ArrayList<File> proofJsons = new ArrayList<File>();
        for (File pendingBlocksPath : pendingBlocksPaths) {
            File[] pendingJsons = Objects.requireNonNull(pendingBlocksPath.listFiles((dir, name) -> name.endsWith(".pnd.json")));
            proofJsons.addAll(Arrays.asList(pendingJsons));
        }
        if (proofJsons.isEmpty()) {
            logger.warn("No pending blocks found in any subdirectories of {}", (Object)blockDirPath);
            return pendingBlocks;
        }
        proofJsons.sort(PROOF_JSON_FILE_COMPARATOR.reversed());
        logger.info("Evaluating {} pending blocks on disk", (Object)proofJsons.size());
        long nextContiguousBlock = followingBlockNumber - 1L;
        for (int i = 0; i < proofJsons.size(); ++i) {
            PendingProof pendingProof;
            File proofJson = (File)proofJsons.get(i);
            long nextNumber = PROOF_JSON_BLOCK_NUMBER_FN.applyAsLong(proofJson);
            if (nextNumber != nextContiguousBlock) {
                logger.info("No more contiguous blocks (#{} != #{})", (Object)nextNumber, (Object)nextContiguousBlock);
                break;
            }
            logger.info("Trying to load next contiguous pending block #{}", (Object)nextNumber);
            --nextContiguousBlock;
            Path proofJsonPath = proofJson.toPath();
            try {
                pendingProof = (PendingProof)PendingProof.JSON.parse((ReadableSequentialData)new ReadableStreamingData(proofJsonPath));
            }
            catch (ParseException | IOException e) {
                logger.warn("Error reading pending proof metadata from {} (not considering remaining - {})", (Object)proofJson.toPath(), (Object)Arrays.toString(Arrays.copyOfRange(proofJsons.toArray(), i + 1, proofJsons.size())));
                break;
            }
            if (pendingProof.blockTimestamp() == null || Objects.equals(pendingProof.blockTimestamp(), Timestamp.DEFAULT) || pendingProof.siblingHashesFromPrevBlockRoot().size() != 3) {
                logger.warn("Pending proof metadata from {} doesn't match required fields (not considering remaining - {})", (Object)proofJson.toPath(), (Object)Arrays.toString(Arrays.copyOfRange(proofJsons.toArray(), i + 1, proofJsons.size())));
                break;
            }
            Block partialBlock = null;
            String name2 = proofJson.getName();
            Path contentsPath = proofJson.toPath().resolveSibling(name2.replace(".pnd.json", ".pnd.gz"));
            if (contentsPath.toFile().exists()) {
                try (GZIPInputStream in = new GZIPInputStream(Files.newInputStream(contentsPath, new OpenOption[0]));){
                    partialBlock = FileBlockItemWriter.parseBlock(in.readAllBytes(), maxReadDepth, maxReadSize);
                }
                catch (ParseException | IOException e) {
                    logger.error("Error reading zipped pending block contents from {}", (Object)contentsPath, (Object)e);
                }
            } else {
                contentsPath = proofJson.toPath().resolveSibling(name2.replace(".pnd.json", ".pnd"));
                if (contentsPath.toFile().exists()) {
                    try {
                        partialBlock = FileBlockItemWriter.parseBlock(Files.readAllBytes(contentsPath), maxReadDepth, maxReadSize);
                    }
                    catch (ParseException | IOException e) {
                        logger.error("Error reading pending block contents from {}", (Object)contentsPath, (Object)e);
                    }
                }
            }
            if (partialBlock == null) {
                logger.warn("No pending block contents found for {} (not considering remaining - {})", (Object)proofJson.toPath(), (Object)Arrays.toString(Arrays.copyOfRange(proofJsons.toArray(), i + 1, proofJsons.size())));
                break;
            }
            pendingBlocks.addFirst(new OnDiskPendingBlock(partialBlock.items(), pendingProof, proofJsonPath, contentsPath));
        }
        return pendingBlocks;
    }

    private static Block parseBlock(byte[] bytes, int maxReadDepth, int maxReadSize) throws ParseException {
        return (Block)Block.PROTOBUF.parse(Bytes.wrap((byte[])bytes).toReadableSequentialData(), false, false, maxReadDepth, maxReadSize);
    }

    public static void cleanUpPendingBlock(@NonNull Path contentsPath) {
        Objects.requireNonNull(contentsPath);
        String name = contentsPath.getFileName().toString();
        String suffix = name.endsWith(".pnd.gz") ? ".pnd.gz" : ".pnd";
        Path proofJsonPath = contentsPath.resolveSibling(name.replace(suffix, ".pnd.json"));
        logger.info("Cleaning up pending block ({}, {})", (Object)proofJsonPath, (Object)contentsPath);
        if (!proofJsonPath.toFile().delete()) {
            logger.warn("Failed to delete pending proof metadata at {}", (Object)proofJsonPath);
        }
        if (!contentsPath.toFile().delete()) {
            logger.warn("Failed to delete pending block contents at {}", (Object)contentsPath);
        }
    }

    @Override
    public void openBlock(long blockNumber) {
        if (this.state == State.OPEN) {
            throw new IllegalStateException("Cannot initialize a FileBlockItemWriter twice");
        }
        if (blockNumber < 0L) {
            throw new IllegalArgumentException("Block number must be non-negative");
        }
        this.blockNumber = blockNumber;
        Path blockFilePath = this.pathOf(blockNumber, this.completeFileName);
        OutputStream out = null;
        try {
            if (!Files.exists(this.nodeScopedBlockDir, new LinkOption[0])) {
                Files.createDirectories(this.nodeScopedBlockDir, new FileAttribute[0]);
            }
            out = Files.newOutputStream(blockFilePath, new OpenOption[0]);
            out = new BufferedOutputStream(out, 0x100000);
            out = new GZIPOutputStream(out, 262144);
            out = new BufferedOutputStream(out, 0x400000);
            this.writableStreamingData = new WritableStreamingData(out);
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    logger.error("Error closing the FileBlockItemWriter output stream", (Throwable)ex);
                }
            }
            logger.fatal("Could not create block file {}", (Object)blockFilePath, (Object)e);
            throw new UncheckedIOException(e);
        }
        this.state = State.OPEN;
        if (logger.isDebugEnabled()) {
            logger.debug("Started new block in FileBlockItemWriter {}", (Object)blockNumber);
        }
    }

    void writeItem(@NonNull byte[] bytes) {
        Objects.requireNonNull(bytes);
        if (this.state != State.OPEN) {
            throw new IllegalStateException("Cannot write to a FileBlockItemWriter that is not open for block: " + this.blockNumber);
        }
        ProtoWriterTools.writeTag((WritableSequentialData)this.writableStreamingData, (FieldDefinition)BlockSchema.ITEMS, (ProtoConstants)ProtoConstants.WIRE_TYPE_DELIMITED);
        this.writableStreamingData.writeVarInt(bytes.length, false);
        this.writableStreamingData.writeBytes(bytes);
    }

    @Override
    public void writePbjItemAndBytes(@NonNull BlockItem item, @NonNull Bytes bytes) {
        Objects.requireNonNull(bytes, "bytes must not be null");
        this.writeItem(bytes.toByteArray());
    }

    @Override
    public void writePbjItem(@NonNull BlockItem item) {
        throw new UnsupportedOperationException("writePbjItem is not supported in this implementation");
    }

    @Override
    public void closeCompleteBlock() {
        if (this.state.ordinal() < State.OPEN.ordinal()) {
            throw new IllegalStateException("Cannot close a FileBlockItemWriter that is not open");
        }
        if (this.state.ordinal() == State.CLOSED.ordinal()) {
            throw new IllegalStateException("Cannot close a FileBlockItemWriter that is already closed");
        }
        try {
            Path markerFile;
            this.writableStreamingData.close();
            this.state = State.CLOSED;
            if (logger.isDebugEnabled()) {
                logger.debug("Closed block in FileBlockItemWriter {}", (Object)this.blockNumber);
            }
            if (Files.exists(markerFile = this.pathOf(this.blockNumber, name -> name + ".mf"), new LinkOption[0])) {
                logger.info("Skipping block marker file for {} as it already exists", (Object)markerFile);
            } else {
                Files.createFile(markerFile, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error closing the FileBlockItemWriter output stream", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flushPendingBlock(@NonNull PendingProof pendingProof) {
        Objects.requireNonNull(pendingProof);
        if (this.state == State.OPEN) {
            try {
                this.writableStreamingData.close();
                this.writableStreamingData.flush();
                Files.move(this.pathOf(this.blockNumber, this.completeFileName), this.pathOf(this.blockNumber, this.pendingFileName), new CopyOption[0]);
            }
            catch (IOException e) {
                logger.error("Error flushing pending block #{}", (Object)this.blockNumber, (Object)e);
                return;
            }
            finally {
                this.state = State.CLOSED;
            }
            String json = PendingProof.JSON.toJSON((Object)pendingProof);
            try {
                Files.writeString(this.pathOf(this.blockNumber, name -> name + ".pnd.json"), (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("Error flushing pending proof metadata #{}", (Object)this.blockNumber, (Object)e);
            }
            logger.info("Flushed pending block #{} ({}, {})", (Object)this.blockNumber, (Object)this.pathOf(this.blockNumber, this.pendingFileName), (Object)this.pathOf(this.blockNumber, name -> name + ".pnd.json"));
        } else {
            logger.warn("Block #{} flushed in non-OPEN state '{}'", (Object)this.blockNumber, (Object)this.state, (Object)new IllegalStateException());
        }
    }

    @Override
    public void jumpToBlockAfterFreeze(long blockNumber) {
    }

    @NonNull
    private Path pathOf(long blockNumber, @NonNull UnaryOperator<String> nameFn) {
        return this.nodeScopedBlockDir.resolve((String)nameFn.apply(FileBlockItemWriter.longToFileName(blockNumber)));
    }

    @NonNull
    public static String longToFileName(long value) {
        BigInteger unsignedValue = BigInteger.valueOf(value & Long.MAX_VALUE).add(BigInteger.valueOf(Long.MIN_VALUE & value));
        return String.format("%036d", unsignedValue);
    }

    private static enum State {
        UNINITIALIZED,
        OPEN,
        CLOSED;

    }

    public record OnDiskPendingBlock(@NonNull List<BlockItem> items, @NonNull PendingProof pendingProof, @NonNull Path proofJsonPath, @NonNull Path contentsPath) {
        public OnDiskPendingBlock {
            Objects.requireNonNull(items);
            Objects.requireNonNull(pendingProof);
            Objects.requireNonNull(proofJsonPath);
            Objects.requireNonNull(contentsPath);
        }

        public long number() {
            return this.pendingProof.block();
        }

        public Bytes blockHash() {
            return this.pendingProof.blockHash();
        }

        public BlockProof.Builder proofBuilder() {
            return BlockProof.newBuilder().block(this.pendingProof().block());
        }

        public MerkleSiblingHash[] siblingHashesIfUseful() {
            return this.pendingProof.siblingHashesFromPrevBlockRoot().toArray(new MerkleSiblingHash[0]);
        }
    }
}

