/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.signature.AppKeyVerifier;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeCalculatorFactory;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;

public class ChildFeeContextImpl
implements FeeContext {
    private final FeeManager feeManager;
    private final FeeContext context;
    private final TransactionBody body;
    private final AccountID payerId;
    private final boolean computeFeesAsInternalDispatch;
    private final Authorizer authorizer;
    private final ReadableStoreFactory storeFactory;
    private final Instant consensusNow;
    @Nullable
    private final AppKeyVerifier verifier;
    private final int signatureMapSize;
    private final HederaFunctionality functionality;

    public ChildFeeContextImpl(@NonNull FeeManager feeManager, @NonNull FeeContext context, @NonNull TransactionBody body, @NonNull AccountID payerId, boolean computeFeesAsInternalDispatch, @NonNull Authorizer authorizer, @NonNull ReadableStoreFactory storeFactory, @NonNull Instant consensusNow, @Nullable AppKeyVerifier verifier, int signatureMapSize, @NonNull HederaFunctionality functionality) {
        this.feeManager = Objects.requireNonNull(feeManager);
        this.context = Objects.requireNonNull(context);
        this.body = Objects.requireNonNull(body);
        this.payerId = Objects.requireNonNull(payerId);
        this.computeFeesAsInternalDispatch = computeFeesAsInternalDispatch;
        this.authorizer = Objects.requireNonNull(authorizer);
        this.storeFactory = Objects.requireNonNull(storeFactory);
        this.consensusNow = Objects.requireNonNull(consensusNow);
        this.verifier = verifier;
        this.signatureMapSize = signatureMapSize;
        this.functionality = Objects.requireNonNull(functionality);
    }

    @NonNull
    public AccountID payer() {
        return this.payerId;
    }

    @NonNull
    public TransactionBody body() {
        return this.body;
    }

    @NonNull
    private FeeCalculator createFeeCalculator(@NonNull SubType subType) {
        try {
            return this.feeManager.createFeeCalculator(this.body, this.getPayerKey(), HapiUtils.functionOf((TransactionBody)this.body), this.numTxnSignatures(), this.signatureMapSize, this.consensusNow, subType, this.computeFeesAsInternalDispatch, this.storeFactory);
        }
        catch (UnknownHederaFunctionality e) {
            throw new IllegalStateException("Child fee context was constructed with invalid transaction body " + String.valueOf(this.body), e);
        }
    }

    @NonNull
    public FeeCalculatorFactory feeCalculatorFactory() {
        return this::createFeeCalculator;
    }

    public SimpleFeeCalculator getSimpleFeeCalculator() {
        return this.feeManager.getSimpleFeeCalculator();
    }

    @NonNull
    public ReadableStoreFactory readableStoreFactory() {
        return this.storeFactory;
    }

    @NonNull
    public <T> T readableStore(@NonNull Class<T> storeInterface) {
        return (T)this.storeFactory.readableStore(storeInterface);
    }

    @NonNull
    public Configuration configuration() {
        return this.context.configuration();
    }

    @Nullable
    public Authorizer authorizer() {
        return this.authorizer;
    }

    public int numTxnSignatures() {
        return this.verifier == null ? 0 : this.verifier.numSignaturesVerified();
    }

    public int numTxnBytes() {
        return TransactionBody.PROTOBUF.measureRecord((Object)this.body) + this.signatureMapSize;
    }

    public Fees dispatchComputeFees(@NonNull TransactionBody txBody, @NonNull AccountID syntheticPayerId) {
        return this.context.dispatchComputeFees(txBody, syntheticPayerId);
    }

    private Key getPayerKey() {
        Account account = ((ReadableAccountStore)this.context.readableStore(ReadableAccountStore.class)).getAccountById(this.payerId);
        return this.computeFeesAsInternalDispatch || account == null ? Key.DEFAULT : account.keyOrThrow();
    }

    public ExchangeRate activeRate() {
        return this.context.activeRate();
    }

    public long getGasPriceInTinycents() {
        return this.feeManager.getGasPriceInTinyCents(this.consensusNow);
    }

    public HederaFunctionality functionality() {
        return this.functionality;
    }
}

