/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Flow;
import org.hiero.block.api.PublishStreamRequest;
import org.hiero.block.api.PublishStreamResponse;

public interface BlockStreamPublishServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "BlockStreamPublishService";
    public static final String FULL_NAME = "org.hiero.block.api.BlockStreamPublishService";

    @NonNull
    public Pipeline<? super PublishStreamRequest> publishBlockStream(@NonNull Pipeline<? super PublishStreamResponse> var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(BlockStreamPublishServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        BlockStreamPublishServiceMethod m = (BlockStreamPublishServiceMethod)method;
        try {
            switch (m.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Pipelines.bidiStreaming().mapRequest(bytes -> BlockStreamPublishServiceInterface.parsePublishStreamRequest(bytes, options)).method(this::publishBlockStream).mapResponse(reply -> BlockStreamPublishServiceInterface.serializePublishStreamResponse(reply, options)).respondTo(replies).build();
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<PublishStreamRequest> getPublishStreamRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return PublishStreamRequest.JSON;
        }
        return PublishStreamRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<PublishStreamResponse> getPublishStreamResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return PublishStreamResponse.JSON;
        }
        return PublishStreamResponse.PROTOBUF;
    }

    @NonNull
    private static PublishStreamRequest parsePublishStreamRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (PublishStreamRequest)BlockStreamPublishServiceInterface.getPublishStreamRequestCodec(options).parse(message.toReadableSequentialData(), false, false, 16, options.maxMessageSizeBytes());
    }

    @NonNull
    private static Bytes serializePublishStreamResponse(@NonNull PublishStreamResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return BlockStreamPublishServiceInterface.getPublishStreamResponseCodec(options).toBytes((Object)reply);
    }

    public static enum BlockStreamPublishServiceMethod implements ServiceInterface.Method
    {
        publishBlockStream;

    }

    public static class BlockStreamPublishServiceClient
    implements BlockStreamPublishServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public BlockStreamPublishServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public Pipeline<? super PublishStreamRequest> publishBlockStream(final @NonNull Pipeline<? super PublishStreamResponse> replies) {
            Pipeline<PublishStreamResponse> pipeline = new Pipeline<PublishStreamResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    replies.onSubscribe(subscription);
                }

                public void onNext(PublishStreamResponse reply) {
                    replies.onNext((Object)reply);
                }

                public void onError(Throwable throwable) {
                    replies.onError(throwable);
                }

                public void onComplete() {
                    replies.onComplete();
                }
            };
            final GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.BlockStreamPublishService/publishBlockStream", BlockStreamPublishServiceInterface.getPublishStreamRequestCodec(this.requestOptions), BlockStreamPublishServiceInterface.getPublishStreamResponseCodec(this.requestOptions), (Pipeline)pipeline);
            return new Pipeline<PublishStreamRequest>(){

                public void onSubscribe(Flow.Subscription subscription) {
                }

                public void onNext(PublishStreamRequest request) {
                    call.sendRequest((Object)request, false);
                }

                public void onError(Throwable throwable) {
                    replies.onError(throwable);
                }

                public void onComplete() {
                    call.completeRequests();
                    replies.onComplete();
                }
            };
        }
    }
}

