/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.decimals;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.hapi.utils.HederaExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.decimals.DecimalsTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class DecimalsCall
extends AbstractRevertibleTokenViewCall {
    private static final int MAX_REPORTABLE_DECIMALS = 255;

    public DecimalsCall(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull SystemContractGasCalculator gasCalculator, @Nullable Token token) {
        super(gasCalculator, enhancement, token);
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        if (this.token != null && this.token.tokenType() != TokenType.FUNGIBLE_COMMON) {
            return Call.PricedResult.gasOnly(FullResult.haltResult(HederaExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_TOKEN_ID, false);
        }
        return super.execute();
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        int decimals = Math.min(255, token.decimals());
        return Call.PricedResult.gasOnly(FullResult.successResult(DecimalsTranslator.DECIMALS.getOutputs().encode((Object)Tuple.singleton((Object)decimals)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
    }
}

