/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;

public class TapDoubleIterable
extends AbstractLazyDoubleIterable {
    private final DoubleIterable adapted;
    private final DoubleProcedure procedure;

    public TapDoubleIterable(DoubleIterable delegate, DoubleProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    public void each(DoubleProcedure procedure) {
        this.adapted.forEach((DoubleProcedure & Serializable)each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.adapted.anySatisfy((DoublePredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.adapted.allSatisfy((DoublePredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.adapted.noneSatisfy((DoublePredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.adapted.detectIfNone((DoublePredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    public DoubleIterator doubleIterator() {
        return new TapDoubleIterator(this.adapted, this.procedure);
    }

    public static class TapDoubleIterator
    implements DoubleIterator {
        private final DoubleIterator iterator;
        private final DoubleProcedure procedure;

        public TapDoubleIterator(DoubleIterable iterable, DoubleProcedure procedure) {
            this(iterable.doubleIterator(), procedure);
        }

        public TapDoubleIterator(DoubleIterator iterator, DoubleProcedure procedure) {
            this.iterator = iterator;
            this.procedure = procedure;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public double next() {
            double next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

