/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.io.extendable.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hiero.consensus.io.extendable.InputStreamExtension;
import org.hiero.consensus.io.extendable.OutputStreamExtension;

public abstract class AbstractStreamExtension
implements InputStreamExtension,
OutputStreamExtension {
    private InputStream inputStream;
    private OutputStream outputStream;

    @Override
    public void init(InputStream baseStream) {
        this.inputStream = baseStream;
    }

    @Override
    public void init(OutputStream baseStream) {
        this.outputStream = baseStream;
    }

    protected abstract void newByte(int var1) throws IOException;

    protected abstract void newBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public int read() throws IOException {
        int aByte = this.inputStream.read();
        if (aByte != -1) {
            this.newByte(aByte);
        }
        return aByte;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count = this.inputStream.read(bytes, offset, length);
        if (count != -1) {
            this.newBytes(bytes, offset, count);
        }
        return count;
    }

    @Override
    public byte[] readNBytes(int length) throws IOException {
        byte[] bytes = this.inputStream.readNBytes(length);
        this.newBytes(bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public int readNBytes(byte[] bytes, int offset, int length) throws IOException {
        int count = this.inputStream.readNBytes(bytes, offset, length);
        this.newBytes(bytes, offset, count);
        return count;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.newByte(b);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.outputStream.write(bytes, offset, length);
        this.newBytes(bytes, offset, length);
    }

    @Override
    public void close() {
    }
}

