/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.token.TokenMintTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class TokenMintFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.TOKEN_MINT);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        TokenMintTransactionBody op = txnBody.tokenMintOrThrow();
        if (op.amount() == 0L) {
            this.addExtraFee(feeResult, serviceDef, Extra.TOKEN_MINT_NFT_BASE, feeSchedule, 1L);
            this.addExtraFee(feeResult, serviceDef, Extra.TOKEN_MINT_NFT, feeSchedule, op.metadata().size());
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.TOKEN_MINT;
    }
}

